/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox;

import com.antgroup.geaflow.api.graph.function.vc.VertexCentricCombineFunction;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox.IGraphMsgBox;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;

public class CombinedMsgBox<K, MESSAGE>
implements IGraphMsgBox<K, MESSAGE> {
    private final Map<K, MESSAGE> inMessageBox;
    private final Map<K, MESSAGE> outMessageBox;
    private final VertexCentricCombineFunction<MESSAGE> combineFunction;

    public CombinedMsgBox(VertexCentricCombineFunction<MESSAGE> combineFunction) {
        this.combineFunction = combineFunction;
        this.inMessageBox = new HashMap<K, MESSAGE>();
        this.outMessageBox = new HashMap<K, MESSAGE>();
    }

    @Override
    public void addInMessages(K vertexId, MESSAGE message) {
        MESSAGE oldMessage = this.inMessageBox.get(vertexId);
        if (oldMessage != null) {
            Object newMessage = this.combineFunction.combine(oldMessage, message);
            this.inMessageBox.put(vertexId, newMessage);
        } else {
            this.inMessageBox.put(vertexId, message);
        }
    }

    @Override
    public void processInMessage(IGraphMsgBox.MsgProcessFunc<K, MESSAGE> processFunc) {
        this.processMessage(this.inMessageBox, processFunc);
    }

    @Override
    public void clearInBox() {
        this.inMessageBox.clear();
    }

    @Override
    public void addOutMessage(K vertexId, MESSAGE message) {
        this.addMessage(this.outMessageBox, vertexId, message);
    }

    @Override
    public void processOutMessage(IGraphMsgBox.MsgProcessFunc<K, MESSAGE> processFunc) {
        this.processMessage(this.outMessageBox, processFunc);
    }

    @Override
    public void clearOutBox() {
        this.outMessageBox.clear();
    }

    private void processMessage(Map<K, MESSAGE> messageBox, IGraphMsgBox.MsgProcessFunc<K, MESSAGE> processFunc) {
        for (Map.Entry<K, MESSAGE> entry : messageBox.entrySet()) {
            processFunc.process(entry.getKey(), Lists.newArrayList((Object[])new Object[]{entry.getValue()}));
        }
    }

    private void addMessage(Map<K, MESSAGE> messageBox, K vertexId, MESSAGE message) {
        MESSAGE oldMessage = messageBox.get(vertexId);
        if (oldMessage != null) {
            Object newMessage = this.combineFunction.combine(oldMessage, message);
            messageBox.put(vertexId, newMessage);
        } else {
            messageBox.put(vertexId, message);
        }
    }

    @VisibleForTesting
    protected Map<K, MESSAGE> getInMessageBox() {
        return this.inMessageBox;
    }

    @VisibleForTesting
    protected Map<K, MESSAGE> getOutMessageBox() {
        return this.outMessageBox;
    }
}

