/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.compute.dynamic;

import com.antgroup.geaflow.api.graph.base.algo.VertexCentricAlgo;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.CheckpointUtil;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.meta.GraphMeta;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.AbstractGraphVertexCentricOp;
import com.antgroup.geaflow.operator.impl.graph.compute.dynamic.cache.TemporaryGraphCache;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.antgroup.geaflow.view.meta.ViewMetaBookKeeper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicGraphVertexCentricOp<K, VV, EV, M, FUNC extends VertexCentricAlgo<K, VV, EV, M>>
extends AbstractGraphVertexCentricOp<K, VV, EV, M, FUNC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDynamicGraphVertexCentricOp.class);
    protected TemporaryGraphCache<K, VV, EV> temporaryGraphCache;
    private long checkpointDuration;

    public AbstractDynamicGraphVertexCentricOp(GraphViewDesc graphViewDesc, FUNC func) {
        super(graphViewDesc, func);
        assert (!graphViewDesc.isStatic());
        this.opArgs.setOpType(OpArgs.OpType.INC_VERTEX_CENTRIC_COMPUTE);
        this.opArgs.setChainStrategy(OpArgs.ChainStrategy.NEVER);
        this.maxIterations = ((VertexCentricAlgo)this.function).getMaxIterationCount();
    }

    @Override
    public void open(Operator.OpContext opContext) {
        super.open(opContext);
        this.temporaryGraphCache = new TemporaryGraphCache();
        this.checkpointDuration = this.runtimeContext.getConfiguration().getLong(FrameworkConfigKeys.BATCH_NUMBER_PER_CHECKPOINT);
    }

    @Override
    public void addVertex(IVertex<K, VV> vertex) {
        if (this.enableDebug) {
            LOGGER.info("taskId:{} windowId:{} iterations:{} add vertex:{}", new Object[]{this.runtimeContext.getTaskArgs().getTaskId(), this.windowId, this.iterations, vertex});
        }
        this.temporaryGraphCache.addVertex(vertex);
        this.opInputMeter.mark();
    }

    @Override
    public void addEdge(IEdge<K, EV> edge) {
        if (this.enableDebug) {
            LOGGER.info("taskId:{} windowId:{} iterations:{} add edge:{}", new Object[]{this.runtimeContext.getTaskArgs().getTaskId(), this.windowId, this.iterations, edge});
        }
        this.temporaryGraphCache.addEdge(edge);
        this.opInputMeter.mark();
    }

    @Override
    public void close() {
        this.temporaryGraphCache.clear();
        this.graphMsgBox.clearInBox();
        this.graphMsgBox.clearOutBox();
        this.graphState.manage().operate().close();
    }

    @Override
    protected GraphStateDescriptor<K, VV, EV> buildGraphStateDesc(String name) {
        GraphStateDescriptor desc = super.buildGraphStateDesc(name);
        desc.withDataModel(DataModel.DYNAMIC_GRAPH);
        desc.withGraphMeta(new GraphMeta(this.graphViewDesc.getGraphMetaType()));
        return desc;
    }

    public GraphViewDesc getGraphViewDesc() {
        return this.graphViewDesc;
    }

    protected void checkpoint() {
        if (CheckpointUtil.needDoCheckpoint((long)this.windowId, (long)this.checkpointDuration)) {
            LOGGER.info("opName:{} do checkpoint for windowId:{}, checkpoint duration:{}", new Object[]{this.opArgs.getOpName(), this.windowId, this.checkpointDuration});
            long checkpoint = this.graphViewDesc.getCheckpoint(this.windowId);
            LOGGER.info("do checkpoint, checkpointId: {}", (Object)checkpoint);
            this.graphState.manage().operate().setCheckpointId(checkpoint);
            this.graphState.manage().operate().finish();
            this.graphState.manage().operate().archive();
        }
    }

    @Override
    protected void recover() {
        long lastCheckPointId;
        LOGGER.info("opName: {} will do recover, windowId: {}", (Object)this.opArgs.getOpName(), (Object)this.windowId);
        try {
            ViewMetaBookKeeper keeper = new ViewMetaBookKeeper(this.graphViewDesc.getName(), this.runtimeContext.getConfiguration());
            lastCheckPointId = keeper.getLatestViewVersion(this.graphViewDesc.getName());
            LOGGER.info("opName: {} will do recover, ViewMetaBookKeeper version: {}", (Object)this.opArgs.getOpName(), (Object)lastCheckPointId);
        }
        catch (IOException e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
        if (lastCheckPointId >= 0L) {
            LOGGER.info("opName: {} do recover to state VersionId: {}", (Object)this.opArgs.getOpName(), (Object)lastCheckPointId);
            this.graphState.manage().operate().setCheckpointId(lastCheckPointId);
            this.graphState.manage().operate().recover();
        } else {
            LOGGER.info("lastCheckPointId < 0");
            if (this.windowId > 1L) {
                long recoverVersionId = this.graphViewDesc.getCheckpoint(this.windowId - 1L);
                LOGGER.info("opName: {} do recover to latestVersionId: {}", (Object)this.opArgs.getOpName(), (Object)recoverVersionId);
                this.graphState.manage().operate().setCheckpointId(recoverVersionId);
                this.graphState.manage().operate().recover();
            }
        }
    }
}

