/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.compute.dynamic.cache;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TemporaryGraphCache<K, VV, EV> {
    private final Set<K> vertexIds = new HashSet<K>();
    private final Map<K, IVertex<K, VV>> vertices = new HashMap<K, IVertex<K, VV>>();
    private final Map<K, List<IEdge<K, EV>>> vertexEdges = new HashMap<K, List<IEdge<K, EV>>>();

    public void addVertex(IVertex<K, VV> vertex) {
        this.vertexIds.add(vertex.getId());
        this.vertices.put(vertex.getId(), vertex);
    }

    public IVertex<K, VV> getVertex(K vId) {
        return this.vertices.get(vId);
    }

    public void addEdge(IEdge<K, EV> edge) {
        this.vertexIds.add(edge.getSrcId());
        List edges = this.vertexEdges.getOrDefault(edge.getSrcId(), new ArrayList());
        edges.add(edge);
        this.vertexEdges.put(edge.getSrcId(), edges);
    }

    public List<IEdge<K, EV>> getEdges(K vId) {
        return this.vertexEdges.get(vId);
    }

    public Set<K> getAllEvolveVId() {
        return this.vertexIds;
    }

    public void clear() {
        this.vertexIds.clear();
        this.vertices.clear();
        this.vertexEdges.clear();
    }
}

