/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.traversal.dynamic;

import com.antgroup.geaflow.api.graph.base.algo.AbstractIncVertexCentricTraversalAlgo;
import com.antgroup.geaflow.api.graph.function.vc.IncVertexCentricTraversalFunction;
import com.antgroup.geaflow.model.traversal.ITraversalRequest;
import com.antgroup.geaflow.model.traversal.impl.VertexBeginTraversalRequest;
import com.antgroup.geaflow.operator.impl.graph.traversal.dynamic.AbstractDynamicGraphVertexCentricTraversalOp;
import com.antgroup.geaflow.utils.keygroup.KeyGroupAssignment;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicGraphVertexCentricTraversalStartByIdsOp<K, VV, EV, M, R, FUNC extends IncVertexCentricTraversalFunction<K, VV, EV, M, R>>
extends AbstractDynamicGraphVertexCentricTraversalOp<K, VV, EV, M, R, FUNC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicGraphVertexCentricTraversalStartByIdsOp.class);
    private final List<ITraversalRequest<K>> traversalRequests = new ArrayList<ITraversalRequest<K>>();

    public DynamicGraphVertexCentricTraversalStartByIdsOp(GraphViewDesc graphViewDesc, VertexBeginTraversalRequest<K> vertexBeginTraversalRequest, AbstractIncVertexCentricTraversalAlgo<K, VV, EV, M, R, FUNC> vcTraversal) {
        super(graphViewDesc, vcTraversal);
        this.traversalRequests.add((ITraversalRequest<K>)vertexBeginTraversalRequest);
    }

    public DynamicGraphVertexCentricTraversalStartByIdsOp(GraphViewDesc graphViewDesc, List<VertexBeginTraversalRequest<K>> vertexBeginTraversalRequests, AbstractIncVertexCentricTraversalAlgo<K, VV, EV, M, R, FUNC> vcTraversal) {
        super(graphViewDesc, vcTraversal);
        this.traversalRequests.addAll(vertexBeginTraversalRequests);
    }

    @Override
    protected void traversalByRequest() {
        if (!this.temporaryGraphCache.getAllEvolveVId().isEmpty()) {
            if (this.enableDebug) {
                LOGGER.info("taskId:{} windowId:{} iterations:{} is not empty", new Object[]{this.runtimeContext.getTaskArgs().getTaskId(), this.windowId, this.iterations});
            }
            super.traversalByRequest();
        } else {
            LOGGER.info("taskId:{} windowId:{} iterations:{} is empty", new Object[]{this.runtimeContext.getTaskArgs().getTaskId(), this.windowId, this.iterations});
        }
    }

    @Override
    public Iterator<ITraversalRequest<K>> getTraversalRequests() {
        ArrayList<ITraversalRequest<K>> currentTaskRequest = new ArrayList<ITraversalRequest<K>>();
        for (ITraversalRequest<K> traversalRequest : this.traversalRequests) {
            int maxParallelism = this.graphViewDesc.getShardNum();
            int currentKeyGroup = KeyGroupAssignment.assignToKeyGroup((Object)traversalRequest.getVId(), (int)maxParallelism);
            if (currentKeyGroup < this.taskKeyGroup.getStartKeyGroup() || currentKeyGroup > this.taskKeyGroup.getEndKeyGroup()) continue;
            currentTaskRequest.add(traversalRequest);
        }
        return currentTaskRequest.iterator();
    }
}

