/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.traversal.statical;

import com.antgroup.geaflow.api.graph.base.algo.AbstractVertexCentricTraversalAlgo;
import com.antgroup.geaflow.api.graph.function.vc.VertexCentricTraversalFunction;
import com.antgroup.geaflow.model.traversal.ITraversalRequest;
import com.antgroup.geaflow.model.traversal.impl.VertexBeginTraversalRequest;
import com.antgroup.geaflow.operator.impl.graph.traversal.statical.AbstractStaticGraphVertexCentricTraversalOp;
import com.antgroup.geaflow.utils.keygroup.KeyGroupAssignment;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticGraphVertexCentricTraversalStartByIdsOp<K, VV, EV, M, R, FUNC extends VertexCentricTraversalFunction<K, VV, EV, M, R>>
extends AbstractStaticGraphVertexCentricTraversalOp<K, VV, EV, M, R, FUNC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticGraphVertexCentricTraversalStartByIdsOp.class);
    private final List<ITraversalRequest<K>> traversalRequests = new ArrayList<ITraversalRequest<K>>();

    public StaticGraphVertexCentricTraversalStartByIdsOp(GraphViewDesc graphViewDesc, VertexBeginTraversalRequest<K> vertexBeginTraversalRequest, AbstractVertexCentricTraversalAlgo<K, VV, EV, M, R, FUNC> vcTraversal) {
        super(graphViewDesc, vcTraversal);
        this.traversalRequests.add((ITraversalRequest<K>)vertexBeginTraversalRequest);
    }

    public StaticGraphVertexCentricTraversalStartByIdsOp(GraphViewDesc graphViewDesc, List<VertexBeginTraversalRequest<K>> vertexBeginTraversalRequests, AbstractVertexCentricTraversalAlgo<K, VV, EV, M, R, FUNC> vcTraversal) {
        super(graphViewDesc, vcTraversal);
        this.traversalRequests.addAll(vertexBeginTraversalRequests);
    }

    @Override
    public Iterator<ITraversalRequest<K>> getTraversalRequests() {
        ArrayList<ITraversalRequest<K>> currentTaskRequest = new ArrayList<ITraversalRequest<K>>();
        for (ITraversalRequest<K> traversalRequest : this.traversalRequests) {
            int maxParallelism = this.graphViewDesc.getShardNum();
            int currentKeyGroup = KeyGroupAssignment.assignToKeyGroup((Object)traversalRequest.getVId(), (int)maxParallelism);
            LOGGER.info("maxParallelism {}", (Object)maxParallelism);
            if (currentKeyGroup < this.taskKeyGroup.getStartKeyGroup() || currentKeyGroup > this.taskKeyGroup.getEndKeyGroup()) continue;
            currentTaskRequest.add(traversalRequest);
        }
        return currentTaskRequest.iterator();
    }
}

