/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.context;

import com.antgroup.geaflow.api.pdata.base.PAction;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import com.antgroup.geaflow.view.IViewDesc;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineContext
implements IPipelineContext,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPipelineContext.class);
    protected final AtomicInteger idGenerator = new AtomicInteger(0);
    protected Configuration pipelineConfig;
    protected transient List<PAction> actions;
    protected transient Map<String, IViewDesc> viewDescMap;

    public AbstractPipelineContext(Configuration pipelineConfig) {
        this.pipelineConfig = pipelineConfig;
        this.actions = new ArrayList<PAction>();
        this.viewDescMap = new HashMap<String, IViewDesc>();
    }

    public int generateId() {
        return this.idGenerator.incrementAndGet();
    }

    public void addPAction(PAction action) {
        LOGGER.info("Add Action, Id:{}", (Object)action.getId());
        this.actions.add(action);
    }

    public void addView(IViewDesc viewDesc) {
        LOGGER.info("User ViewName:{} ViewDesc:{}", (Object)viewDesc.getName(), (Object)viewDesc);
        this.viewDescMap.put(viewDesc.getName(), viewDesc);
    }

    public IViewDesc getViewDesc(String name) {
        IViewDesc viewDesc = this.viewDescMap.get(name);
        Preconditions.checkArgument((viewDesc != null ? 1 : 0) != 0);
        return viewDesc;
    }

    public Configuration getConfig() {
        return this.pipelineConfig;
    }

    public List<PAction> getActions() {
        return this.actions.stream().collect(Collectors.toList());
    }
}

