/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pdata.graph.view.compute;

import com.antgroup.geaflow.api.graph.base.algo.GraphExecAlgo;
import com.antgroup.geaflow.api.graph.compute.IncVertexCentricAggCompute;
import com.antgroup.geaflow.api.graph.compute.IncVertexCentricCompute;
import com.antgroup.geaflow.api.graph.compute.PGraphCompute;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowStream;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.operator.impl.graph.compute.dynamic.DynamicGraphVertexCentricComputeOp;
import com.antgroup.geaflow.operator.impl.graph.compute.dynamic.DynamicGraphVertexCentricComputeWithAggOp;
import com.antgroup.geaflow.pdata.graph.view.AbstractGraphView;
import com.antgroup.geaflow.pdata.stream.TransformType;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import com.antgroup.geaflow.view.IViewDesc;
import com.google.common.base.Preconditions;

public class ComputeIncGraph<K, VV, EV, M>
extends AbstractGraphView<K, VV, EV, M, IVertex<K, VV>>
implements PGraphCompute<K, VV, EV> {
    public ComputeIncGraph(IPipelineContext pipelineContext, IViewDesc graphViewDesc, PWindowStream<IVertex<K, VV>> vertexWindowStream, PWindowStream<IEdge<K, EV>> edgeWindowStream) {
        super(pipelineContext, graphViewDesc, vertexWindowStream, edgeWindowStream);
    }

    public PWindowStream<IVertex<K, VV>> computeOnIncVertexCentric(IncVertexCentricCompute<K, VV, EV, M> incVertexCentricCompute) {
        this.processOnVertexCentric(incVertexCentricCompute);
        DynamicGraphVertexCentricComputeOp graphVertexCentricComputeOp = new DynamicGraphVertexCentricComputeOp(this.graphViewDesc, incVertexCentricCompute);
        this.operator = (Operator)graphVertexCentricComputeOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(incVertexCentricCompute.getName());
        return this;
    }

    public <I, PA, PR, GA, GR> PWindowStream<IVertex<K, VV>> computeOnIncVertexCentric(IncVertexCentricAggCompute<K, VV, EV, M, I, PA, PR, GA, GR> incVertexCentricCompute) {
        this.processOnVertexCentric(incVertexCentricCompute);
        DynamicGraphVertexCentricComputeWithAggOp graphVertexCentricComputeOp = new DynamicGraphVertexCentricComputeWithAggOp(this.graphViewDesc, incVertexCentricCompute);
        this.operator = (Operator)graphVertexCentricComputeOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(incVertexCentricCompute.getName());
        return this;
    }

    public PGraphCompute<K, VV, EV> compute() {
        return this;
    }

    public PGraphCompute<K, VV, EV> compute(int parallelism) {
        Preconditions.checkArgument((parallelism <= this.graphViewDesc.getShardNum() ? 1 : 0) != 0, (Object)"op parallelism must be <= shard num");
        this.parallelism = parallelism;
        return this;
    }

    public PWindowStream<IVertex<K, VV>> getVertices() {
        return this;
    }

    public GraphExecAlgo getGraphComputeType() {
        return this.graphExecAlgo;
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.ContinueGraphCompute;
    }
}

