/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pdata.stream;

import com.antgroup.geaflow.api.pdata.base.PData;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.partitioner.IPartitioner;
import com.antgroup.geaflow.partitioner.impl.ForwardPartitioner;
import com.antgroup.geaflow.pdata.stream.TransformType;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import java.io.Serializable;
import java.util.Map;

public abstract class Stream<T>
implements PData,
Serializable {
    private int id;
    protected int parallelism = 1;
    protected Stream input;
    protected OpArgs opArgs;
    protected Operator operator;
    protected IPipelineContext context;
    protected IEncoder<T> encoder;

    protected Stream() {
    }

    public Stream(IPipelineContext context) {
        this.id = context.generateId();
        this.context = context;
    }

    public Stream(IPipelineContext context, Operator operator) {
        this(context);
        this.operator = operator;
        this.opArgs = ((AbstractOperator)operator).getOpArgs();
        this.opArgs.setOpId(this.id);
    }

    public Stream(Stream dataStream, Operator operator) {
        this(dataStream.getContext(), operator);
        this.input = dataStream;
        this.parallelism = this.input.getParallelism();
        this.opArgs.setParallelism(this.parallelism);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    protected void updateId() {
        this.id = this.context.generateId();
    }

    public Operator getOperator() {
        this.opArgs.setOpId(this.id);
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
        if (this.input != null) {
            this.opArgs.setParallelism(this.input.getParallelism());
        }
    }

    public IPipelineContext getContext() {
        return this.context;
    }

    public <S extends Stream<T>> S getInput() {
        return (S)this.input;
    }

    public IPartitioner getPartition() {
        return new ForwardPartitioner(this.getId());
    }

    public int getParallelism() {
        return this.parallelism;
    }

    protected void setParallelism(int parallelism) {
        this.parallelism = parallelism;
        this.opArgs.setParallelism(parallelism);
    }

    protected void setName(String name) {
        this.opArgs.setOpName(name);
    }

    public void setConfig(Map<String, String> config) {
        this.opArgs.setConfig(config);
    }

    public void setConfig(String key, String value) {
        this.opArgs.getConfig().put(key, value);
    }

    public TransformType getTransformType() {
        return TransformType.StreamTransform;
    }

    public Stream<T> withEncoder(IEncoder<T> encoder) {
        this.encoder = encoder;
        return this;
    }

    public IEncoder<T> getEncoder() {
        return this.encoder;
    }
}

