/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pdata.graph.view;

import com.antgroup.geaflow.api.graph.PGraphWindow;
import com.antgroup.geaflow.api.graph.compute.IncVertexCentricAggCompute;
import com.antgroup.geaflow.api.graph.compute.IncVertexCentricCompute;
import com.antgroup.geaflow.api.graph.compute.PGraphCompute;
import com.antgroup.geaflow.api.graph.traversal.IncVertexCentricAggTraversal;
import com.antgroup.geaflow.api.graph.traversal.IncVertexCentricTraversal;
import com.antgroup.geaflow.api.graph.traversal.PGraphTraversal;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowStream;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.pdata.graph.view.compute.ComputeIncGraph;
import com.antgroup.geaflow.pdata.graph.view.materialize.MaterializedIncGraph;
import com.antgroup.geaflow.pdata.graph.view.traversal.TraversalIncGraph;
import com.antgroup.geaflow.pdata.graph.window.WindowStreamGraph;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import com.antgroup.geaflow.view.IViewDesc;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.antgroup.geaflow.view.graph.PGraphView;
import com.antgroup.geaflow.view.graph.PIncGraphView;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncGraphView<K, VV, EV>
implements PIncGraphView<K, VV, EV> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncGraphView.class);
    private IPipelineContext pipelineContext;
    private PWindowStream<IVertex<K, VV>> vertexWindowSteam;
    private PWindowStream<IEdge<K, EV>> edgeWindowStream;
    private IViewDesc graphViewDesc;
    @VisibleForTesting
    private MaterializedIncGraph<K, VV, EV> materializedIncGraph;

    public IncGraphView(IPipelineContext pipelineContext, IViewDesc viewDesc) {
        this.pipelineContext = pipelineContext;
        this.graphViewDesc = viewDesc;
    }

    public PGraphView<K, VV, EV> init(GraphViewDesc graphViewDesc) {
        this.graphViewDesc = graphViewDesc;
        return this;
    }

    public PGraphWindow<K, VV, EV> snapshot(long version) {
        return new WindowStreamGraph((GraphViewDesc)((GraphViewDesc)this.graphViewDesc).snapshot(version), this.pipelineContext);
    }

    public PIncGraphView<K, VV, EV> appendGraph(PWindowStream<IVertex<K, VV>> vertexStream, PWindowStream<IEdge<K, EV>> edgeStream) {
        this.vertexWindowSteam = vertexStream;
        this.edgeWindowStream = edgeStream;
        return this;
    }

    public PIncGraphView<K, VV, EV> appendEdge(PWindowStream<IEdge<K, EV>> edgeStream) {
        this.edgeWindowStream = edgeStream;
        return this;
    }

    public PIncGraphView<K, VV, EV> appendVertex(PWindowStream<IVertex<K, VV>> vertexStream) {
        this.vertexWindowSteam = vertexStream;
        return this;
    }

    public <M> PGraphCompute<K, VV, EV> incrementalCompute(IncVertexCentricCompute<K, VV, EV, M> incVertexCentricCompute) {
        ComputeIncGraph<K, VV, EV, M> computeIncGraph = new ComputeIncGraph<K, VV, EV, M>(this.pipelineContext, this.graphViewDesc, this.vertexWindowSteam, this.edgeWindowStream);
        computeIncGraph.computeOnIncVertexCentric(incVertexCentricCompute);
        return computeIncGraph;
    }

    public <M, I, PA, PR, GA, GR> PGraphCompute<K, VV, EV> incrementalCompute(IncVertexCentricAggCompute<K, VV, EV, M, I, PA, PR, GA, GR> incVertexCentricCompute) {
        ComputeIncGraph<K, VV, EV, M> computeIncGraph = new ComputeIncGraph<K, VV, EV, M>(this.pipelineContext, this.graphViewDesc, this.vertexWindowSteam, this.edgeWindowStream);
        computeIncGraph.computeOnIncVertexCentric(incVertexCentricCompute);
        return null;
    }

    public <M, R> PGraphTraversal<K, R> incrementalTraversal(IncVertexCentricTraversal<K, VV, EV, M, R> incVertexCentricTraversal) {
        TraversalIncGraph traversalIncGraph = new TraversalIncGraph(this.pipelineContext, this.graphViewDesc, this.vertexWindowSteam, this.edgeWindowStream);
        traversalIncGraph.traversalOnVertexCentric(incVertexCentricTraversal);
        return traversalIncGraph;
    }

    public <M, R, I, PA, PR, GA, GR> PGraphTraversal<K, R> incrementalTraversal(IncVertexCentricAggTraversal<K, VV, EV, M, R, I, PA, PR, GA, GR> incVertexCentricTraversal) {
        TraversalIncGraph traversalIncGraph = new TraversalIncGraph(this.pipelineContext, this.graphViewDesc, this.vertexWindowSteam, this.edgeWindowStream);
        traversalIncGraph.traversalOnVertexCentric(incVertexCentricTraversal);
        return traversalIncGraph;
    }

    public void materialize() {
        this.materializedIncGraph = new MaterializedIncGraph<K, VV, EV>(this.pipelineContext, this.graphViewDesc, this.vertexWindowSteam, this.edgeWindowStream);
        this.materializedIncGraph.materialize();
    }

    @VisibleForTesting
    public MaterializedIncGraph getMaterializedIncGraph() {
        return this.materializedIncGraph;
    }
}

