/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pdata.graph.view.traversal;

import com.antgroup.geaflow.api.function.base.KeySelector;
import com.antgroup.geaflow.api.graph.base.algo.AbstractIncVertexCentricTraversalAlgo;
import com.antgroup.geaflow.api.graph.base.algo.GraphAggregationAlgo;
import com.antgroup.geaflow.api.graph.base.algo.GraphExecAlgo;
import com.antgroup.geaflow.api.graph.traversal.IncVertexCentricAggTraversal;
import com.antgroup.geaflow.api.graph.traversal.IncVertexCentricTraversal;
import com.antgroup.geaflow.api.graph.traversal.PGraphTraversal;
import com.antgroup.geaflow.api.partition.graph.request.DefaultTraversalRequestPartition;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowBroadcastStream;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowStream;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.model.traversal.ITraversalRequest;
import com.antgroup.geaflow.model.traversal.ITraversalResponse;
import com.antgroup.geaflow.model.traversal.impl.VertexBeginTraversalRequest;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.GraphVertexCentricOpFactory;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphVertexCentricOp;
import com.antgroup.geaflow.pdata.graph.view.AbstractGraphView;
import com.antgroup.geaflow.pdata.stream.TransformType;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import com.antgroup.geaflow.view.IViewDesc;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TraversalIncGraph<K, VV, EV, M, R>
extends AbstractGraphView<K, VV, EV, M, ITraversalResponse<R>>
implements PGraphTraversal<K, R> {
    protected PWindowStream<? extends ITraversalRequest<K>> requestStream;
    protected AbstractIncVertexCentricTraversalAlgo<K, VV, EV, M, R, ?> incVertexCentricTraversal;

    public TraversalIncGraph(IPipelineContext pipelineContext, IViewDesc graphViewDesc, PWindowStream<IVertex<K, VV>> vertexWindowStream, PWindowStream<IEdge<K, EV>> edgeWindowStream) {
        super(pipelineContext, graphViewDesc, vertexWindowStream, edgeWindowStream);
        this.vertexStream = vertexWindowStream;
        this.edgeStream = edgeWindowStream;
        this.graphViewDesc = (GraphViewDesc)graphViewDesc;
        this.parallelism = Math.max(this.vertexStream.getParallelism(), this.edgeStream.getParallelism());
    }

    public TraversalIncGraph<K, VV, EV, M, R> traversalOnVertexCentric(AbstractIncVertexCentricTraversalAlgo<K, VV, EV, M, R, ?> incVertexCentricTraversal) {
        this.processOnVertexCentric(incVertexCentricTraversal);
        this.incVertexCentricTraversal = incVertexCentricTraversal;
        return this;
    }

    public PWindowStream<ITraversalResponse<R>> start() {
        IGraphVertexCentricOp traversalOp = this.incVertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalAllOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricAggTraversal)((IncVertexCentricAggTraversal)this.incVertexCentricTraversal)) : GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalAllOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricTraversal)((IncVertexCentricTraversal)this.incVertexCentricTraversal));
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.incVertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    public PWindowStream<ITraversalResponse<R>> start(K vId) {
        return this.start(Lists.newArrayList((Object[])new Object[]{vId}));
    }

    public PWindowStream<ITraversalResponse<R>> start(List<K> vIds) {
        ArrayList<VertexBeginTraversalRequest> vertexBeginTraversalRequests = new ArrayList<VertexBeginTraversalRequest>();
        for (K vId : vIds) {
            VertexBeginTraversalRequest vertexBeginTraversalRequest = new VertexBeginTraversalRequest(vId);
            vertexBeginTraversalRequests.add(vertexBeginTraversalRequest);
        }
        IGraphVertexCentricOp traversalOp = this.incVertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricAggTraversal)((IncVertexCentricAggTraversal)this.incVertexCentricTraversal), vertexBeginTraversalRequests) : GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricTraversal)((IncVertexCentricTraversal)this.incVertexCentricTraversal), vertexBeginTraversalRequests);
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.incVertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    public PWindowStream<ITraversalResponse<R>> start(PWindowStream<? extends ITraversalRequest<K>> requests) {
        this.requestStream = requests instanceof PWindowBroadcastStream ? requests : requests.keyBy((KeySelector)new DefaultTraversalRequestPartition());
        IGraphVertexCentricOp traversalOp = this.incVertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricAggTraversal)((IncVertexCentricAggTraversal)this.incVertexCentricTraversal)) : GraphVertexCentricOpFactory.buildDynamicGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (IncVertexCentricTraversal)((IncVertexCentricTraversal)this.incVertexCentricTraversal));
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.incVertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    public GraphExecAlgo getGraphTraversalType() {
        return this.graphExecAlgo;
    }

    @Override
    public TraversalIncGraph<K, VV, EV, M, R> withParallelism(int parallelism) {
        this.setParallelism(parallelism);
        return this;
    }

    public PWindowStream<? extends ITraversalRequest<K>> getRequestStream() {
        return this.requestStream;
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.ContinueGraphTraversal;
    }
}

