/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.pdata.graph.window.traversal;

import com.antgroup.geaflow.api.function.base.KeySelector;
import com.antgroup.geaflow.api.graph.base.algo.AbstractVertexCentricTraversalAlgo;
import com.antgroup.geaflow.api.graph.base.algo.GraphAggregationAlgo;
import com.antgroup.geaflow.api.graph.base.algo.GraphExecAlgo;
import com.antgroup.geaflow.api.graph.traversal.PGraphTraversal;
import com.antgroup.geaflow.api.graph.traversal.VertexCentricAggTraversal;
import com.antgroup.geaflow.api.graph.traversal.VertexCentricTraversal;
import com.antgroup.geaflow.api.partition.graph.request.DefaultTraversalRequestPartition;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowBroadcastStream;
import com.antgroup.geaflow.api.pdata.stream.window.PWindowStream;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.model.traversal.ITraversalRequest;
import com.antgroup.geaflow.model.traversal.ITraversalResponse;
import com.antgroup.geaflow.model.traversal.impl.VertexBeginTraversalRequest;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.GraphVertexCentricOpFactory;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphVertexCentricOp;
import com.antgroup.geaflow.pdata.graph.window.AbstractGraphWindow;
import com.antgroup.geaflow.pdata.stream.Stream;
import com.antgroup.geaflow.pdata.stream.TransformType;
import com.antgroup.geaflow.pipeline.context.IPipelineContext;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TraversalWindowGraph<K, VV, EV, M, R>
extends AbstractGraphWindow<K, VV, EV, M, ITraversalResponse<R>>
implements PGraphTraversal<K, R> {
    protected PWindowStream<? extends ITraversalRequest<K>> requestStream;
    protected AbstractVertexCentricTraversalAlgo<K, VV, EV, M, R, ?> vertexCentricTraversal;
    private final GraphViewDesc graphViewDesc;

    public TraversalWindowGraph(GraphViewDesc graphViewDesc, IPipelineContext pipelineContext, PWindowStream<IVertex<K, VV>> vertexWindowStream, PWindowStream<IEdge<K, EV>> edgeWindowStream) {
        super(pipelineContext, vertexWindowStream, edgeWindowStream);
        this.input = (Stream)vertexWindowStream;
        this.edgeStream = edgeWindowStream;
        this.graphViewDesc = graphViewDesc;
    }

    public void traversalOnVertexCentric(VertexCentricTraversal<K, VV, EV, M, R> vertexCentricTraversal) {
        this.vertexCentricTraversal = vertexCentricTraversal;
        this.processOnVertexCentric(vertexCentricTraversal);
        this.graphExecAlgo = GraphExecAlgo.VertexCentric;
        this.maxIterations = vertexCentricTraversal.getMaxIterationCount();
    }

    public <I, PA, PR, GA, GR> void traversalOnVertexCentric(VertexCentricAggTraversal<K, VV, EV, M, R, I, PA, PR, GA, GR> vertexCentricTraversal) {
        this.vertexCentricTraversal = vertexCentricTraversal;
        this.processOnVertexCentric(vertexCentricTraversal);
        this.graphExecAlgo = GraphExecAlgo.VertexCentric;
        this.maxIterations = vertexCentricTraversal.getMaxIterationCount();
    }

    public PWindowStream<ITraversalResponse<R>> start() {
        IGraphVertexCentricOp traversalOp = this.vertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildStaticGraphVertexCentricAggTraversalAllOp((GraphViewDesc)this.graphViewDesc, (VertexCentricAggTraversal)((VertexCentricAggTraversal)this.vertexCentricTraversal)) : GraphVertexCentricOpFactory.buildStaticGraphVertexCentricTraversalAllOp((GraphViewDesc)this.graphViewDesc, (VertexCentricTraversal)((VertexCentricTraversal)this.vertexCentricTraversal));
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.vertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    public PWindowStream<ITraversalResponse<R>> start(K vId) {
        return this.start(Lists.newArrayList((Object[])new Object[]{vId}));
    }

    public PWindowStream<ITraversalResponse<R>> start(List<K> vIds) {
        ArrayList<VertexBeginTraversalRequest> vertexBeginTraversalRequests = new ArrayList<VertexBeginTraversalRequest>();
        for (K vId : vIds) {
            VertexBeginTraversalRequest vertexBeginTraversalRequest = new VertexBeginTraversalRequest(vId);
            vertexBeginTraversalRequests.add(vertexBeginTraversalRequest);
        }
        IGraphVertexCentricOp traversalOp = this.vertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildStaticGraphVertexCentricAggTraversalOp((GraphViewDesc)this.graphViewDesc, (VertexCentricAggTraversal)((VertexCentricAggTraversal)this.vertexCentricTraversal), vertexBeginTraversalRequests) : GraphVertexCentricOpFactory.buildStaticGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (VertexCentricTraversal)((VertexCentricTraversal)this.vertexCentricTraversal), vertexBeginTraversalRequests);
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.vertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    public PWindowStream<ITraversalResponse<R>> start(PWindowStream<? extends ITraversalRequest<K>> requests) {
        this.requestStream = requests instanceof PWindowBroadcastStream ? requests : requests.keyBy((KeySelector)new DefaultTraversalRequestPartition());
        IGraphVertexCentricOp traversalOp = this.vertexCentricTraversal instanceof GraphAggregationAlgo ? GraphVertexCentricOpFactory.buildStaticGraphVertexCentricAggTraversalOp((GraphViewDesc)this.graphViewDesc, (VertexCentricAggTraversal)((VertexCentricAggTraversal)this.vertexCentricTraversal)) : GraphVertexCentricOpFactory.buildStaticGraphVertexCentricTraversalOp((GraphViewDesc)this.graphViewDesc, (VertexCentricTraversal)((VertexCentricTraversal)this.vertexCentricTraversal));
        this.operator = (Operator)traversalOp;
        this.opArgs = ((AbstractOperator)this.operator).getOpArgs();
        this.opArgs.setOpId(this.getId());
        this.opArgs.setOpName(this.vertexCentricTraversal.getName());
        this.opArgs.setParallelism(this.parallelism);
        return this;
    }

    @Override
    public TraversalWindowGraph<K, VV, EV, M, R> withParallelism(int parallelism) {
        this.setParallelism(parallelism);
        return this;
    }

    public GraphExecAlgo getGraphTraversalType() {
        return this.graphExecAlgo;
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.WindowGraphTraversal;
    }

    public PWindowStream<? extends ITraversalRequest<K>> getRequestStream() {
        return this.requestStream;
    }
}

