/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.core.graph;

import com.antgroup.geaflow.cluster.resourcemanager.WorkerInfo;
import com.antgroup.geaflow.common.task.TaskArgs;
import com.antgroup.geaflow.common.utils.LoggerFormatter;
import com.antgroup.geaflow.core.graph.ExecutionTaskType;
import com.antgroup.geaflow.processor.Processor;
import java.io.Serializable;

public class ExecutionTask
implements Serializable {
    private int taskId;
    private int index;
    private int vertexId;
    private int parallelism;
    private int maxParallelism;
    private int numPartitions;
    private WorkerInfo workerInfo;
    private Processor processor;
    private ExecutionTaskType executionTaskType;
    private boolean iterative;
    private long startTime;
    private long duration;
    private transient String taskName;

    public ExecutionTask(int taskId, int index, int parallelism, int maxParallelism, int numPartitions, int vertexId) {
        this.taskId = taskId;
        this.index = index;
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
        this.numPartitions = numPartitions;
        this.vertexId = vertexId;
        this.workerInfo = null;
        this.startTime = -1L;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(int vertexId) {
        this.vertexId = vertexId;
    }

    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    public void setWorkerInfo(WorkerInfo workerInfo) {
        this.workerInfo = workerInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public ExecutionTaskType getExecutionTaskType() {
        return this.executionTaskType;
    }

    public void setExecutionTaskType(ExecutionTaskType executionTaskType) {
        this.executionTaskType = executionTaskType;
    }

    public void setIterative(boolean iterative) {
        this.iterative = iterative;
    }

    public boolean isIterative() {
        return this.iterative;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void buildTaskName(String pipelineName, int cycleId, long windowId) {
        this.taskName = this.iterative ? LoggerFormatter.getTaskTag((String)pipelineName, (int)cycleId, (long)windowId, (int)this.taskId, (int)this.vertexId, (int)this.index, (int)this.parallelism) : LoggerFormatter.getTaskTag((String)pipelineName, (int)cycleId, (int)this.taskId, (int)this.vertexId, (int)this.index, (int)this.parallelism);
    }

    public TaskArgs buildTaskArgs() {
        return new TaskArgs(this.taskId, this.index, this.taskName, this.parallelism, this.maxParallelism);
    }

    public String toString() {
        return "ExecutionTask{taskId=" + this.taskId + ", index=" + this.index + ", vertexId=" + this.vertexId + ", worker=" + (this.workerInfo == null ? "NULL" : this.workerInfo) + '}';
    }
}

