/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.graph;

import com.antgroup.geaflow.plan.graph.PipelineEdge;
import com.antgroup.geaflow.plan.graph.PipelineVertex;
import com.antgroup.geaflow.plan.graph.VertexType;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineGraph
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineGraph.class);
    private final Map<Integer, PipelineVertex> vertexMap = new HashMap<Integer, PipelineVertex>();
    private final Map<Integer, PipelineEdge> edgeMap = new LinkedHashMap<Integer, PipelineEdge>();
    private final Map<Integer, List<Integer>> vertexOutputEdgeIds = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, List<Integer>> vertexInputEdgeIds = new HashMap<Integer, List<Integer>>();

    public void addVertex(PipelineVertex pipelineVertex) {
        LOGGER.info("add vertex:{} {}", (Object)pipelineVertex.getVertexId(), (Object)pipelineVertex.getName());
        this.vertexMap.put(pipelineVertex.getVertexId(), pipelineVertex);
    }

    public void setPipelineVertices(Set<PipelineVertex> pipelineVertices) {
        this.vertexMap.clear();
        pipelineVertices.stream().forEach(pipelineVertex -> this.addVertex((PipelineVertex)pipelineVertex));
    }

    public void addEdge(PipelineEdge pipelineEdge) {
        LOGGER.info("add edgeId:{}, edgeName:{}, srcId:{}, targetId:{}", new Object[]{pipelineEdge.getEdgeId(), pipelineEdge.getEdgeName(), pipelineEdge.getSrcId(), pipelineEdge.getTargetId()});
        this.edgeMap.put(pipelineEdge.getEdgeId(), pipelineEdge);
        int edgeId = pipelineEdge.getEdgeId();
        int srcId = pipelineEdge.getSrcId();
        int tarId = pipelineEdge.getTargetId();
        if (this.vertexOutputEdgeIds.containsKey(srcId)) {
            this.vertexOutputEdgeIds.get(srcId).add(edgeId);
        } else {
            this.vertexOutputEdgeIds.put(srcId, Lists.newArrayList((Object[])new Integer[]{edgeId}));
        }
        if (this.vertexInputEdgeIds.containsKey(tarId)) {
            this.vertexInputEdgeIds.get(tarId).add(edgeId);
        } else {
            this.vertexInputEdgeIds.put(tarId, Lists.newArrayList((Object[])new Integer[]{edgeId}));
        }
    }

    public void setPipelineEdges(Set<PipelineEdge> pipelineEdges) {
        this.edgeMap.clear();
        this.vertexInputEdgeIds.clear();
        this.vertexOutputEdgeIds.clear();
        pipelineEdges.stream().forEach(pipelineEdge -> this.addEdge((PipelineEdge)pipelineEdge));
    }

    public Collection<PipelineEdge> getPipelineEdgeList() {
        return this.edgeMap.values();
    }

    public Map<Integer, PipelineVertex> getVertexMap() {
        return this.vertexMap;
    }

    public Collection<PipelineVertex> getPipelineVertices() {
        return this.vertexMap.values();
    }

    public Set<PipelineEdge> getVertexOutEdges(int vertexId) {
        return this.getVertexEdgesByIds(this.vertexOutputEdgeIds.get(vertexId));
    }

    public Set<PipelineEdge> getVertexInputEdges(int vertexId) {
        return this.getVertexEdgesByIds(this.vertexInputEdgeIds.get(vertexId));
    }

    private Set<PipelineEdge> getVertexEdgesByIds(List<Integer> edgeIds) {
        if (edgeIds == null) {
            return new HashSet<PipelineEdge>();
        }
        LinkedHashSet<PipelineEdge> edges = new LinkedHashSet<PipelineEdge>();
        edgeIds.stream().map(id -> this.edgeMap.get(id)).forEach(edges::add);
        return edges;
    }

    public Map<Integer, Set<PipelineEdge>> getVertexInputEdges() {
        HashMap<Integer, Set<PipelineEdge>> inputEdges = new HashMap<Integer, Set<PipelineEdge>>(this.vertexMap.size());
        Iterator<Serializable> iterator = this.vertexMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            inputEdges.put(key, new HashSet());
        }
        for (PipelineEdge executeEdge : this.getPipelineEdgeList()) {
            ((Set)inputEdges.get(executeEdge.getTargetId())).add(executeEdge);
        }
        return inputEdges;
    }

    public Map<Integer, Set<PipelineEdge>> getVertexOutputEdges() {
        HashMap<Integer, Set<PipelineEdge>> outputEdges = new HashMap<Integer, Set<PipelineEdge>>(this.vertexMap.size());
        Iterator<Serializable> iterator = this.vertexMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            outputEdges.put(key, new HashSet());
        }
        for (PipelineEdge executeEdge : this.getPipelineEdgeList()) {
            ((Set)outputEdges.get(executeEdge.getSrcId())).add(executeEdge);
        }
        return outputEdges;
    }

    public List<PipelineVertex> getSourceVertices() {
        ArrayList<PipelineVertex> sourceVertices = new ArrayList<PipelineVertex>();
        for (Map.Entry<Integer, PipelineVertex> entry : this.vertexMap.entrySet()) {
            if (entry.getValue().getType() != VertexType.source) continue;
            sourceVertices.add(entry.getValue());
        }
        return sourceVertices;
    }

    public List<Integer> getVertexInputVertexIds(int vertexId) {
        if (this.vertexInputEdgeIds.get(vertexId) != null) {
            return this.vertexInputEdgeIds.get(vertexId).stream().map(edgeId -> this.edgeMap.get(edgeId).getSrcId()).collect(Collectors.toList());
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> getVertexOutputVertexIds(int vertexId) {
        if (this.vertexOutputEdgeIds.get(vertexId) != null) {
            return this.vertexOutputEdgeIds.get(vertexId).stream().map(edgeId -> this.edgeMap.get(edgeId).getTargetId()).collect(Collectors.toList());
        }
        return new ArrayList<Integer>();
    }
}

