/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.util;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.plan.graph.PipelineEdge;
import com.antgroup.geaflow.plan.graph.PipelineGraph;
import com.antgroup.geaflow.plan.graph.PipelineVertex;

public class DAGValidator {
    public static void checkVertexValidity(PipelineGraph pipelineGraph, PipelineVertex pipelineVertex, boolean fetchPrevious) {
        for (PipelineEdge pipelineEdge : pipelineGraph.getPipelineEdgeList()) {
            int vertexId = fetchPrevious ? pipelineEdge.getTargetId() : pipelineEdge.getSrcId();
            if (pipelineVertex.getVertexId() != vertexId) continue;
            int previousChainTailVertexId = pipelineEdge.getPartition().getOpId();
            PipelineVertex previousVertex = null;
            if (pipelineGraph.getVertexMap().containsKey(previousChainTailVertexId)) {
                previousVertex = pipelineGraph.getVertexMap().get(previousChainTailVertexId);
            }
            if (previousVertex != null) continue;
            throw new GeaflowRuntimeException(RuntimeErrors.INST.previousVertexIsNullError(String.valueOf(pipelineVertex.getVertexId())));
        }
    }
}

