/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.visualization;

import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.plan.visualization.OpDesc;

public class GeaFlowNodeInfo {
    private int vertexId;
    private String type;
    private OpDesc operator;
    private int parallelism;

    public GeaFlowNodeInfo(int vertexId, String type, Operator operator) {
        this.vertexId = vertexId;
        this.type = type;
        this.operator = new OpDesc(operator);
        this.parallelism = ((AbstractOperator)operator).getOpArgs().getParallelism();
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(int vertexId) {
        this.vertexId = vertexId;
    }

    public String toGraphvizNodeString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.vertexId).append(" [label=\"");
        builder.append("p:").append(this.parallelism);
        builder.append(", ").append(this.operator.getName());
        builder.append("\"]\n");
        return builder.toString();
    }
}

