/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.visualization;

import com.antgroup.geaflow.common.visualization.console.ConsoleVisualizeVertex;
import com.antgroup.geaflow.common.visualization.console.JsonPlan;
import com.antgroup.geaflow.common.visualization.console.Predecessor;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.plan.graph.PipelineEdge;
import com.antgroup.geaflow.plan.graph.PipelineGraph;
import com.antgroup.geaflow.plan.graph.PipelineVertex;
import com.antgroup.geaflow.plan.graph.VertexType;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class JsonPlanGraphVisualization {
    private final PipelineGraph plan;
    private final JsonPlan jsonPlan;

    public JsonPlanGraphVisualization(PipelineGraph plan) {
        this.plan = plan;
        this.jsonPlan = new JsonPlan();
        this.createJsonPlan(plan);
    }

    private void createJsonPlan(PipelineGraph plan) {
        ArrayList<PipelineVertex> pipelineVertices = new ArrayList<PipelineVertex>(plan.getVertexMap().values());
        pipelineVertices.sort(Comparator.comparingInt(PipelineVertex::getVertexId));
        for (PipelineVertex vertex : pipelineVertices) {
            ConsoleVisualizeVertex v = new ConsoleVisualizeVertex();
            this.decorateNode(vertex, v);
            this.jsonPlan.vertices.put(v.id, v);
        }
    }

    public JsonPlan getJsonPlan() {
        return this.jsonPlan;
    }

    private void decorateNode(PipelineVertex jobVertex, ConsoleVisualizeVertex vertex) {
        AbstractOperator operator;
        vertex.setId(Integer.toString(jobVertex.getVertexId()));
        vertex.setVertexType(jobVertex.getType().name());
        vertex.setParallelism(jobVertex.getParallelism());
        vertex.setVertexMode(jobVertex.getVertexMode() == null ? null : jobVertex.getVertexMode().name());
        if (!vertex.getVertexType().equals(VertexType.source.name())) {
            for (PipelineEdge edge : this.plan.getVertexInputEdges().get(jobVertex.getVertexId())) {
                Predecessor predecessor = new Predecessor();
                predecessor.setId(Integer.toString(edge.getSrcId()));
                predecessor.setPartitionType(edge.getPartitionType().name());
                vertex.getParents().add(predecessor);
            }
        }
        if ((operator = (AbstractOperator)jobVertex.getOperator()).getNextOperators().size() > 0) {
            vertex.setInnerPlan(new JsonPlan());
            this.decorateInnerOperator(vertex.getInnerPlan(), operator, vertex, null);
        } else {
            vertex.setOperator(operator.getClass().getSimpleName());
            vertex.setOperatorName(this.getOperatorName(operator));
        }
    }

    private void decorateInnerOperator(JsonPlan innerPlan, AbstractOperator<?> operator, ConsoleVisualizeVertex outerVertex, String parentId) {
        ConsoleVisualizeVertex vertex = new ConsoleVisualizeVertex();
        vertex.setOperator(operator.getClass().getSimpleName());
        vertex.setOperatorName(this.getOperatorName(operator));
        vertex.setId(outerVertex.getId() + "-" + operator.getOpArgs().getOpId());
        vertex.setParallelism(outerVertex.getParallelism());
        innerPlan.vertices.put(vertex.getId(), vertex);
        if (parentId != null) {
            Predecessor predecessor = new Predecessor();
            predecessor.setId(parentId);
            vertex.getParents().add(predecessor);
        }
        for (Operator op : operator.getNextOperators()) {
            this.decorateInnerOperator(innerPlan, (AbstractOperator)op, outerVertex, vertex.getId());
        }
    }

    private String getOperatorName(AbstractOperator<?> operator) {
        if (StringUtils.isNotBlank((String)operator.getOpArgs().getOpName())) {
            return operator.getOpArgs().getOpName();
        }
        return operator.getIdentify();
    }
}

