/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.core.graph;

import com.antgroup.geaflow.core.graph.ExecutionEdge;
import com.antgroup.geaflow.partitioner.IPartitioner;
import com.antgroup.geaflow.plan.graph.AffinityLevel;
import com.antgroup.geaflow.plan.graph.VertexType;
import com.antgroup.geaflow.processor.Processor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionVertex
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionVertex.class);
    private int vertexId;
    private Processor processor;
    private String name;
    private int parallelism;
    private int maxParallelism;
    private List<Integer> parentVertexIds;
    private List<Integer> childrenVertexIds;
    private int numPartitions;
    private VertexType vertexType;
    private AffinityLevel affinityLevel;
    private VertexType chainTailType;
    private List<ExecutionEdge> inputEdges;
    private List<ExecutionEdge> outputEdges;

    public ExecutionVertex(int vertexId, String name) {
        this.vertexId = vertexId;
        this.name = name;
        this.parentVertexIds = new ArrayList<Integer>();
        this.childrenVertexIds = new ArrayList<Integer>();
        this.inputEdges = null;
        this.outputEdges = null;
        this.affinityLevel = AffinityLevel.worker;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(int vertexId) {
        this.vertexId = vertexId;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public List<Integer> getParentVertexIds() {
        return this.parentVertexIds;
    }

    public void setParentVertexIds(List<Integer> parentVertexIds) {
        this.parentVertexIds = parentVertexIds;
    }

    public List<Integer> getChildrenVertexIds() {
        return this.childrenVertexIds;
    }

    public void setChildrenVertexIds(List<Integer> childrenVertexIds) {
        this.childrenVertexIds = childrenVertexIds;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public List<ExecutionEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public void setVertexType(VertexType vertexType) {
        this.vertexType = vertexType;
    }

    public AffinityLevel getAffinityLevel() {
        return this.affinityLevel;
    }

    public void setAffinityLevel(AffinityLevel affinityLevel) {
        this.affinityLevel = affinityLevel;
    }

    public VertexType getChainTailType() {
        return this.chainTailType;
    }

    public void setChainTailType(VertexType chainTailType) {
        this.chainTailType = chainTailType;
    }

    public boolean isRepartition() {
        if (this.outputEdges != null) {
            boolean isAllForward = this.outputEdges.stream().allMatch(x -> x.getPartitioner().getPartitionType() == IPartitioner.PartitionType.forward);
            return !isAllForward;
        }
        return true;
    }

    public String toString() {
        return "ExecutionVertex{vertexId=" + this.vertexId + ", processor=" + this.processor + ", name='" + this.name + '\'' + '}';
    }
}

