/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.core.graph;

import com.antgroup.geaflow.core.graph.CycleGroupMeta;
import com.antgroup.geaflow.core.graph.ExecutionEdge;
import com.antgroup.geaflow.core.graph.ExecutionVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExecutionVertexGroup
implements Serializable {
    private int groupId;
    private Map<Integer, ExecutionVertex> vertexMap;
    private Map<Integer, ExecutionEdge> edgeMap;
    private Map<Integer, ExecutionEdge> iterationEdgeMap;
    private List<Integer> parentVertexGroupIds;
    private List<Integer> childrenVertexGroupIds;
    private Map<Integer, List<Integer>> vertexId2OutEdgeIds;
    private Map<Integer, List<Integer>> vertexId2InEdgeIds;
    private CycleGroupMeta cycleGroupMeta;

    public ExecutionVertexGroup(int groupId) {
        this.groupId = groupId;
        this.vertexMap = new HashMap<Integer, ExecutionVertex>();
        this.edgeMap = new HashMap<Integer, ExecutionEdge>();
        this.iterationEdgeMap = new HashMap<Integer, ExecutionEdge>();
        this.parentVertexGroupIds = new ArrayList<Integer>();
        this.childrenVertexGroupIds = new ArrayList<Integer>();
        this.vertexId2OutEdgeIds = new HashMap<Integer, List<Integer>>();
        this.vertexId2InEdgeIds = new HashMap<Integer, List<Integer>>();
        this.cycleGroupMeta = new CycleGroupMeta();
    }

    public int getGroupId() {
        return this.groupId;
    }

    public Map<Integer, ExecutionVertex> getVertexMap() {
        return this.vertexMap;
    }

    public Map<Integer, ExecutionEdge> getEdgeMap() {
        return this.edgeMap;
    }

    public Map<Integer, ExecutionEdge> getIterationEdgeMap() {
        return this.iterationEdgeMap;
    }

    public Map<Integer, List<Integer>> getVertexId2OutEdgeIds() {
        return this.vertexId2OutEdgeIds;
    }

    public Map<Integer, List<Integer>> getVertexId2InEdgeIds() {
        return this.vertexId2InEdgeIds;
    }

    public void putVertexId2OutEdgeIds(int vertexId, List<Integer> outEdgeIds) {
        this.vertexId2OutEdgeIds.put(vertexId, outEdgeIds);
    }

    public void putVertexId2InEdgeIds(int vertexId, List<Integer> inEdgeIds) {
        this.vertexId2InEdgeIds.put(vertexId, inEdgeIds);
    }

    public List<Integer> getParentVertexGroupIds() {
        return this.parentVertexGroupIds;
    }

    public List<Integer> getChildrenVertexGroupIds() {
        return this.childrenVertexGroupIds;
    }

    public CycleGroupMeta getCycleGroupMeta() {
        return this.cycleGroupMeta;
    }

    public List<Integer> getTailVertexIds() {
        ArrayList<Integer> tailVertexIds = new ArrayList<Integer>();
        this.vertexMap.keySet().stream().forEach(vertexId -> {
            ArrayList outputVertexIds = new ArrayList();
            this.vertexId2OutEdgeIds.get(vertexId).stream().forEach(edgeId -> {
                if (this.edgeMap.get(edgeId) != null) {
                    outputVertexIds.add(this.edgeMap.get(edgeId).getTargetId());
                }
            });
            if (outputVertexIds.size() == 0) {
                tailVertexIds.add((Integer)vertexId);
            } else {
                boolean flag = false;
                Iterator iterator = outputVertexIds.iterator();
                while (iterator.hasNext()) {
                    int outputVertexId = (Integer)iterator.next();
                    if (this.vertexMap.containsKey(outputVertexId)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    tailVertexIds.add((Integer)vertexId);
                }
            }
        });
        return tailVertexIds;
    }

    public List<Integer> getHeadVertexIds() {
        ArrayList<Integer> headVertexIds = new ArrayList<Integer>();
        this.vertexMap.keySet().stream().forEach(vertexId -> {
            boolean hasNoInputEdge = this.vertexId2InEdgeIds.get(vertexId) == null || this.vertexId2InEdgeIds.get(vertexId).isEmpty();
            boolean isVertexSrcNotInGroup = this.vertexId2InEdgeIds.get(vertexId).stream().anyMatch(edgeId -> !this.vertexMap.containsKey(this.edgeMap.get(edgeId).getSrcId()));
            if (hasNoInputEdge || isVertexSrcNotInGroup) {
                headVertexIds.add((Integer)vertexId);
            }
        });
        return headVertexIds;
    }

    public String toString() {
        return "ExecutionVertexGroup{" + this.vertexMap + ",\n cycleGroupMeta=" + this.cycleGroupMeta + "\n}";
    }
}

