/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.core.graph.plan.visualization;

import com.antgroup.geaflow.core.graph.ExecutionGraph;
import com.antgroup.geaflow.core.graph.ExecutionVertexGroup;
import com.antgroup.geaflow.core.graph.ExecutionVertexGroupEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExecutionGraphVisualization {
    public static final String SCHEDULER = "scheduler";
    private static final String NODE_FORMAT = "%s [label=\"%s\"]\n";
    private static final String EMPTY_GRAPH = "digraph G {\n" + "0 [label=\"node-0\"]\n" + String.format("%s [label=\"%s\"]\n", "scheduler", "scheduler") + "}";
    private ExecutionGraph executionGraph;
    private List<ExecutionVertexGroupEdge> vertexGroupEdgeList;
    private Map<Integer, ExecutionVertexGroup> vertexGroupMap;

    public ExecutionGraphVisualization(ExecutionGraph executionGraph) {
        this.executionGraph = executionGraph;
        this.vertexGroupEdgeList = new ArrayList<ExecutionVertexGroupEdge>(executionGraph.getGroupEdgeMap().values());
        this.vertexGroupMap = executionGraph.getVertexGroupMap();
    }

    public String getExecutionGraphViz() {
        if (this.vertexGroupEdgeList.size() == 0 && this.vertexGroupMap.size() == 0) {
            return EMPTY_GRAPH;
        }
        Collections.sort(this.vertexGroupEdgeList, (o1, o2) -> {
            int i = Integer.compare(o1.getGroupSrcId(), o2.getGroupSrcId());
            if (i == 0) {
                return Integer.compare(o1.getGroupTargetId(), o2.getGroupTargetId());
            }
            return i;
        });
        StringBuilder builder = new StringBuilder("digraph G {\n");
        for (ExecutionVertexGroupEdge vertexGroupEdge : this.vertexGroupEdgeList) {
            builder.append(String.format("%d -> %d [label = \"%s\"]\n", vertexGroupEdge.getGroupSrcId(), vertexGroupEdge.getGroupTargetId(), vertexGroupEdge.getPartitioner().getPartitionType().toString()));
        }
        for (ExecutionVertexGroup vertexGroup : this.vertexGroupMap.values()) {
            builder.append(String.format(NODE_FORMAT, vertexGroup.getGroupId(), vertexGroup));
        }
        builder.append("0 [label=\"node-0\"]\n");
        builder.append(String.format(NODE_FORMAT, SCHEDULER, SCHEDULER));
        builder.append("}");
        return builder.toString();
    }

    public String toString() {
        return this.executionGraph.toString();
    }
}

