/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.graph;

import com.antgroup.geaflow.api.partition.kv.RandomPartition;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.io.CollectType;
import com.antgroup.geaflow.partitioner.IPartitioner;
import java.io.Serializable;
import java.util.Objects;

public class PipelineEdge
implements Serializable {
    private int edgeId;
    private int srcId;
    private int targetId;
    private int streamOrdinal;
    private IPartitioner partition;
    private IPartitioner.PartitionType partitionType;
    private String edgeName;
    private CollectType type;
    private IEncoder<?> encoder;

    public PipelineEdge(int edgeId, int srcId, int targetId, IPartitioner partition, IEncoder<?> encoder) {
        this(edgeId, srcId, targetId, partition, 0, encoder);
    }

    public PipelineEdge(int edgeId, int srcId, int targetId, IPartitioner partition, IEncoder<?> encoder, CollectType type) {
        this(edgeId, srcId, targetId, partition, 0, encoder);
        this.type = type;
    }

    public PipelineEdge(int edgeId, int srcId, int targetId, IPartitioner partition, int streamOrdinal, IEncoder<?> encoder) {
        this.edgeId = edgeId;
        this.srcId = srcId;
        this.targetId = targetId;
        this.partition = partition;
        this.streamOrdinal = streamOrdinal;
        this.partitionType = partition.getPartitionType();
        this.encoder = encoder;
    }

    public IPartitioner.PartitionType getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(IPartitioner.PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public int getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(int edgeId) {
        this.edgeId = edgeId;
    }

    public int getSrcId() {
        return this.srcId;
    }

    public void setSrcId(int srcId) {
        this.srcId = srcId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setTargetId(int targetId) {
        this.targetId = targetId;
    }

    public IPartitioner getPartition() {
        return this.partition;
    }

    public void setPartition(IPartitioner partition) {
        this.partition = partition;
    }

    public int getStreamOrdinal() {
        return this.streamOrdinal;
    }

    public void setStreamOrdinal(int streamOrdinal) {
        this.streamOrdinal = streamOrdinal;
    }

    public IEncoder<?> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(IEncoder<?> encoder) {
        this.encoder = encoder;
    }

    public String getEdgeName() {
        if (this.edgeName != null) {
            return this.edgeName;
        }
        String partitionName = "";
        if (this.partition.getPartition() != null && !(this.partition.getPartition() instanceof RandomPartition)) {
            partitionName = "-partitionFunc-" + this.partition.getPartition().getClass().getSimpleName();
        }
        if (this.srcId != this.targetId) {
            return this.edgeId + "-stream-from" + this.srcId + "-to" + this.targetId + partitionName;
        }
        return this.edgeId + "-stream-from" + this.srcId + "-IteratorStream";
    }

    public CollectType getType() {
        return this.type;
    }

    public void setEdgeName(String edgeName) {
        this.edgeName = edgeName;
    }

    public final int hashCode() {
        return Objects.hash(this.edgeId, this.srcId, this.targetId, this.edgeName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PipelineEdge) {
            PipelineEdge other = (PipelineEdge)obj;
            return other.getSrcId() == this.srcId && other.getTargetId() == this.targetId && other.getEdgeId() == this.edgeId && other.getPartitionType() == this.partitionType && Objects.equals(this.getEdgeName(), other.getEdgeName());
        }
        return false;
    }

    public static enum JoinStream {
        left,
        right,
        none;

    }
}

