/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.graph;

import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.plan.graph.AffinityLevel;
import com.antgroup.geaflow.plan.graph.VertexMode;
import com.antgroup.geaflow.plan.graph.VertexType;
import java.io.Serializable;
import java.util.Objects;

public class PipelineVertex<OP extends Operator>
implements Serializable {
    private int vertexId;
    private OP operator;
    private int parallelism;
    private long iterations;
    private VertexType type;
    private VertexMode vertexMode;
    private AffinityLevel affinity;
    private boolean duplication;
    private VertexType chainTailType;

    public PipelineVertex(int vertexId, OP operator, int parallelism) {
        this.vertexId = vertexId;
        this.operator = operator;
        this.parallelism = parallelism;
        this.iterations = 1L;
        this.affinity = AffinityLevel.worker;
    }

    public PipelineVertex(int vertexId, OP operator, VertexType type, int parallelism) {
        this(vertexId, operator, parallelism);
        this.type = type;
        this.chainTailType = type;
    }

    public PipelineVertex(int vertexId, VertexType vertexType, OP operator, VertexMode vertexMode) {
        this(vertexId, operator, vertexType, ((AbstractOperator)operator).getOpArgs().getParallelism());
        this.vertexMode = vertexMode;
    }

    public boolean isDuplication() {
        return this.duplication;
    }

    public void setDuplication() {
        this.duplication = true;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(int vertexId) {
        this.vertexId = vertexId;
    }

    public OP getOperator() {
        return this.operator;
    }

    public void setOperator(OP operator) {
        this.operator = operator;
    }

    public VertexType getType() {
        return this.type;
    }

    public void setType(VertexType type) {
        this.type = type;
        this.chainTailType = type;
    }

    public String getName() {
        if (this.operator != null) {
            return this.operator.getClass().getSimpleName();
        }
        return null;
    }

    public VertexMode getVertexMode() {
        return this.vertexMode;
    }

    public void setVertexMode(VertexMode vertexMode) {
        this.vertexMode = vertexMode;
    }

    public String getVertexName() {
        return "node-" + this.vertexId;
    }

    public long getIterations() {
        return this.iterations;
    }

    public void setIterations(long iterations) {
        this.iterations = iterations;
    }

    public AffinityLevel getAffinity() {
        return this.affinity;
    }

    public void setAffinity(AffinityLevel affinity) {
        this.affinity = affinity;
    }

    public VertexType getChainTailType() {
        return this.chainTailType;
    }

    public void setChainTailType(VertexType chainTailType) {
        this.chainTailType = chainTailType;
    }

    public String getVertexString() {
        String operatorStr = this.operator.toString();
        return String.format("%s, p:%d, %s", this.getVertexName(), this.parallelism, operatorStr);
    }

    public int hashCode() {
        return Objects.hash(this.getVertexId());
    }

    public boolean equals(Object obj) {
        PipelineVertex other;
        return obj instanceof PipelineVertex && (other = (PipelineVertex)obj).getVertexId() == this.vertexId;
    }
}

