/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.optimizer.strategy;

import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.plan.graph.PipelineGraph;
import com.antgroup.geaflow.plan.graph.PipelineVertex;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleWindowGroupRule
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleWindowGroupRule.class);

    public void apply(PipelineGraph pipelineGraph) {
        List<PipelineVertex> sourceVertexList = pipelineGraph.getSourceVertices();
        boolean isSingleWindow = sourceVertexList.stream().allMatch(v -> ((AbstractOperator)v.getOperator()).getOpArgs().getOpType() == OpArgs.OpType.SINGLE_WINDOW_SOURCE);
        if (isSingleWindow) {
            pipelineGraph.getPipelineVertices().stream().forEach(v -> ((AbstractOperator)v.getOperator()).getOpArgs().setEnGroup(false));
            LOGGER.info("apply no group rule success");
        }
    }
}

