/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.plan.visualization;

import com.alibaba.fastjson.JSON;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.plan.graph.PipelineEdge;
import com.antgroup.geaflow.plan.graph.PipelineGraph;
import com.antgroup.geaflow.plan.graph.PipelineVertex;
import com.antgroup.geaflow.plan.visualization.GeaFlowNodeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanGraphVisualization {
    public static final String SCHEDULER = "scheduler";
    private static final String NODE_FORMAT = "%s [label=\"%s\"]\n";
    private static final String EMPTY_GRAPH = "digraph G {\n" + "0 [label=\"node-0\"]\n" + String.format("%s [label=\"%s\"]\n", "scheduler", "scheduler") + "}";
    private PipelineGraph plan;
    private List<PipelineEdge> pipelineEdgeList;
    private Map<Integer, PipelineVertex> pipelineVertexMap;

    public PlanGraphVisualization(PipelineGraph plan) {
        this.plan = plan;
        this.pipelineEdgeList = new ArrayList<PipelineEdge>(plan.getPipelineEdgeList());
        this.pipelineVertexMap = plan.getVertexMap();
    }

    public String getGraphviz() {
        if (this.pipelineEdgeList.size() == 0 && this.pipelineVertexMap.size() == 0) {
            return EMPTY_GRAPH;
        }
        Collections.sort(this.pipelineEdgeList, (o1, o2) -> {
            int i = Integer.compare(o1.getSrcId(), o2.getSrcId());
            if (i == 0) {
                return Integer.compare(o1.getTargetId(), o2.getTargetId());
            }
            return i;
        });
        StringBuilder builder = new StringBuilder("digraph G {\n");
        for (PipelineEdge edge : this.pipelineEdgeList) {
            builder.append(String.format("%d -> %d [label = \"%s\"]\n", edge.getSrcId(), edge.getTargetId(), edge.getPartitionType().toString()));
        }
        for (PipelineVertex vertex : this.pipelineVertexMap.values()) {
            builder.append(String.format(NODE_FORMAT, vertex.getVertexId(), vertex.getVertexString()));
        }
        builder.append("0 [label=\"node-0\"]\n");
        builder.append(String.format(NODE_FORMAT, SCHEDULER, SCHEDULER));
        builder.append("}");
        return builder.toString();
    }

    public String getNodeInfo() {
        HashMap<String, GeaFlowNodeInfo> id2Info = new HashMap<String, GeaFlowNodeInfo>();
        for (PipelineVertex vertex : this.pipelineVertexMap.values()) {
            GeaFlowNodeInfo node = new GeaFlowNodeInfo(vertex.getVertexId(), vertex.getType().name(), (Operator)vertex.getOperator());
            id2Info.put(vertex.getVertexName(), node);
        }
        return JSON.toJSONString(id2Info);
    }

    public String toString() {
        return this.plan.toString();
    }
}

