/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.processor.impl;

import com.antgroup.geaflow.api.context.RuntimeContext;
import com.antgroup.geaflow.api.trait.CancellableTrait;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.processor.Processor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessor<T, R, OP extends Operator>
implements Processor<T, R>,
CancellableTrait {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessor.class);
    protected OP operator;
    protected List<ICollector> collectors;
    protected RuntimeContext runtimeContext;

    public AbstractProcessor(OP operator) {
        this.operator = operator;
    }

    public OP getOperator() {
        return this.operator;
    }

    @Override
    public int getId() {
        return ((AbstractOperator)this.operator).getOpArgs().getOpId();
    }

    @Override
    public void open(List<ICollector> collectors, RuntimeContext runtimeContext) {
        this.collectors = collectors;
        this.runtimeContext = runtimeContext;
        this.operator.open((Operator.OpContext)new AbstractOperator.DefaultOpContext(collectors, runtimeContext));
    }

    @Override
    public void init(long windowId) {
    }

    @Override
    public void finish(long windowId) {
        this.operator.finish();
    }

    @Override
    public void close() {
        this.operator.close();
    }

    public void cancel() {
        if (this.operator instanceof CancellableTrait) {
            ((CancellableTrait)this.operator).cancel();
        }
    }

    public String toString() {
        return this.operator.getClass().getSimpleName();
    }
}

