/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.processor.impl.graph;

import com.antgroup.geaflow.api.context.RuntimeContext;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.message.IGraphMessage;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.model.record.BatchRecord;
import com.antgroup.geaflow.model.record.RecordArgs;
import com.antgroup.geaflow.model.traversal.ITraversalRequest;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphAggregateOp;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphTraversalOp;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphVertexCentricOp;
import com.antgroup.geaflow.operator.impl.iterator.IteratorOperator;
import com.antgroup.geaflow.processor.impl.AbstractWindowProcessor;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphVertexCentricProcessor<U, OP extends IGraphVertexCentricOp & IteratorOperator>
extends AbstractWindowProcessor<BatchRecord<U>, Void, OP> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphVertexCentricProcessor.class);
    private long iterations;

    public GraphVertexCentricProcessor(OP graphVertexCentricOp) {
        super((Operator)graphVertexCentricOp);
    }

    @Override
    public void open(List<ICollector> collectors, RuntimeContext runtimeContext) {
        super.open(collectors, runtimeContext);
    }

    @Override
    public void init(long batchId) {
        this.iterations = batchId;
    }

    @Override
    public Void process(BatchRecord batchRecord) {
        block15: {
            if (batchRecord == null) break block15;
            ((IteratorOperator)((IGraphVertexCentricOp)this.operator)).initIteration(this.iterations);
            if (((IteratorOperator)((IGraphVertexCentricOp)this.operator)).getMaxIterationCount() >= this.iterations) {
                RecordArgs recordArgs = batchRecord.getRecordArgs();
                RecordArgs.GraphRecordNames graphRecordName = RecordArgs.GraphRecordNames.valueOf((String)recordArgs.getName());
                if (graphRecordName == RecordArgs.GraphRecordNames.Vertex) {
                    Iterator vertexIterator = batchRecord.getMessageIterator();
                    while (vertexIterator.hasNext()) {
                        IVertex vertex = (IVertex)vertexIterator.next();
                        ((IGraphVertexCentricOp)this.operator).addVertex(vertex);
                    }
                } else if (graphRecordName == RecordArgs.GraphRecordNames.Edge) {
                    Iterator edgeIterator = batchRecord.getMessageIterator();
                    while (edgeIterator.hasNext()) {
                        ((IGraphVertexCentricOp)this.operator).addEdge((IEdge)edgeIterator.next());
                    }
                } else if (graphRecordName == RecordArgs.GraphRecordNames.Message) {
                    Iterator graphMessageIterator = batchRecord.getMessageIterator();
                    while (graphMessageIterator.hasNext()) {
                        ((IGraphVertexCentricOp)this.operator).processMessage((IGraphMessage)graphMessageIterator.next());
                    }
                } else if (graphRecordName == RecordArgs.GraphRecordNames.Request) {
                    Iterator requestIterator = batchRecord.getMessageIterator();
                    while (requestIterator.hasNext()) {
                        ((IGraphTraversalOp)this.operator).addRequest((ITraversalRequest)requestIterator.next());
                    }
                } else if (graphRecordName == RecordArgs.GraphRecordNames.Aggregate) {
                    Iterator requestIterator = batchRecord.getMessageIterator();
                    while (requestIterator.hasNext()) {
                        ((IGraphAggregateOp)this.operator).processAggregateResult(requestIterator.next());
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void finish(long batchId) {
        if (batchId > 0L) {
            ((IteratorOperator)((IGraphVertexCentricOp)this.operator)).finishIteration(this.iterations);
        } else {
            ((Operator)((IGraphVertexCentricOp)this.operator)).finish();
        }
    }
}

