/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.processor.impl.window;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.record.BatchRecord;
import com.antgroup.geaflow.operator.base.window.TwoInputOperator;
import com.antgroup.geaflow.processor.impl.AbstractStreamProcessor;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoInputProcessor<T>
extends AbstractStreamProcessor<T, Void, TwoInputOperator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoInputProcessor.class);
    private String leftStream;
    private String rightStream;

    public TwoInputProcessor(TwoInputOperator operator) {
        super(operator);
    }

    @Override
    public Void processElement(BatchRecord batchRecord) {
        try {
            Iterator messageIterator = batchRecord.getMessageIterator();
            String streamName = batchRecord.getStreamName();
            if (this.leftStream.equals(streamName)) {
                while (messageIterator.hasNext()) {
                    Object record = messageIterator.next();
                    ((TwoInputOperator)this.operator).processElementOne(record);
                }
            } else if (this.rightStream.equals(streamName)) {
                while (messageIterator.hasNext()) {
                    Object record = messageIterator.next();
                    ((TwoInputOperator)this.operator).processElementTwo(record);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    public void setLeftStream(String leftStream) {
        this.leftStream = leftStream;
    }

    public void setRightStream(String rightStream) {
        this.rightStream = rightStream;
    }
}

