/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.runtime.shuffle;

import com.antgroup.geaflow.runtime.io.IInputDesc;
import com.antgroup.geaflow.runtime.shuffle.InputDescriptor;
import com.antgroup.geaflow.shuffle.OutputDescriptor;
import java.io.Serializable;

public class IoDescriptor
implements Serializable {
    private InputDescriptor inputDescriptor;
    private OutputDescriptor outputDescriptor;

    public IoDescriptor(InputDescriptor inputDescriptor, OutputDescriptor outputDescriptor) {
        this.inputDescriptor = inputDescriptor;
        this.outputDescriptor = outputDescriptor;
    }

    public InputDescriptor getInputDescriptor() {
        return this.inputDescriptor;
    }

    public void setInputDescriptor(InputDescriptor inputDescriptor) {
        this.inputDescriptor = inputDescriptor;
    }

    public OutputDescriptor getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public void setOutputDescriptor(OutputDescriptor outputDescriptor) {
        this.outputDescriptor = outputDescriptor;
    }

    public int getInputTaskNum() {
        int inputTaskNumber = 0;
        if (this.inputDescriptor != null && this.inputDescriptor.getInputDescMap() != null) {
            for (IInputDesc inputDesc : this.inputDescriptor.getInputDescMap().values()) {
                inputTaskNumber += inputDesc.getInput().size();
            }
        }
        return inputTaskNumber;
    }

    public IoDescriptor clone() {
        InputDescriptor inputDescriptor = null;
        OutputDescriptor outputDescriptor = null;
        if (this.inputDescriptor != null) {
            inputDescriptor = this.inputDescriptor.clone();
        }
        if (this.outputDescriptor != null) {
            outputDescriptor = this.outputDescriptor.clone();
        }
        return new IoDescriptor(inputDescriptor, outputDescriptor);
    }
}

