/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.buffer;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.AbstractBuffer;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.network.protocol.MemoryBytesFileRegion;
import io.netty.channel.FileRegion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeapBuffer
extends AbstractBuffer {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private byte[] bytes;

    public HeapBuffer(byte[] bytes) {
        this(bytes, false);
    }

    public HeapBuffer(byte[] bytes, boolean memoryTrack) {
        super(memoryTrack);
        this.bytes = bytes;
        this.requireMemory(bytes.length);
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public int getBufferSize() {
        return this.bytes == null ? 0 : this.bytes.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        }
    }

    @Override
    public FileRegion toFileRegion() {
        return new MemoryBytesFileRegion(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void release() {
        if (this.bytes != null) {
            int dataSize = this.bytes.length;
            this.releaseMemory(dataSize);
            this.bytes = null;
        }
    }

    public static class HeapBufferBuilder
    extends AbstractBuffer.AbstractBufferBuilder {
        private ByteArrayOutputStream outputStream;

        @Override
        public OutputStream getOutputStream() {
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream(4096);
            }
            return this.outputStream;
        }

        @Override
        public void positionStream(int position) {
        }

        @Override
        public int getBufferSize() {
            return this.outputStream != null ? this.outputStream.size() : 0;
        }

        @Override
        public OutBuffer build() {
            byte[] bytes = this.outputStream.toByteArray();
            this.outputStream.reset();
            this.batchCount = 0;
            return new HeapBuffer(bytes, this.memoryTrack);
        }

        @Override
        public void close() {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    throw new GeaflowRuntimeException((Throwable)e);
                }
                this.outputStream = null;
            }
        }
    }
}

