/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.buffer;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.PipelineSlice;
import java.util.concurrent.atomic.AtomicInteger;

public class PipelineShard {
    private final PipelineSlice[] pipeSlices;
    private final AtomicInteger sliceNum;
    private final transient String taskName;

    public PipelineShard(PipelineSlice[] slices) {
        this.taskName = null;
        this.pipeSlices = slices;
        this.sliceNum = new AtomicInteger(slices.length);
    }

    public PipelineShard(String taskName, PipelineSlice[] slices) {
        this.taskName = taskName;
        this.pipeSlices = slices;
        this.sliceNum = new AtomicInteger(slices.length);
    }

    public PipelineShard(String taskName, PipelineSlice[] slices, int sliceNum) {
        this.taskName = taskName;
        this.pipeSlices = slices;
        this.sliceNum = new AtomicInteger(sliceNum);
    }

    public PipelineSlice getSlice(int sliceIndex) {
        return this.pipeSlices[sliceIndex];
    }

    public PipelineSlice[] getSlices() {
        return this.pipeSlices;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getSliceNum() {
        return this.pipeSlices.length;
    }

    public int getBufferCount() {
        int bufferCount = 0;
        for (int i = 0; i < this.pipeSlices.length; ++i) {
            PipelineSlice slice = this.pipeSlices[i];
            if (slice == null) continue;
            bufferCount += slice.getNumberOfBuffers();
        }
        return bufferCount;
    }

    public boolean hasData() {
        for (PipelineSlice slice : this.pipeSlices) {
            if (!slice.hasNext()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int sliceIndex) {
        PipelineShard pipelineShard = this;
        synchronized (pipelineShard) {
            PipelineSlice slice = this.pipeSlices[sliceIndex];
            if (slice != null) {
                slice.release();
                this.pipeSlices[sliceIndex] = null;
                this.sliceNum.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PipelineShard pipelineShard = this;
        synchronized (pipelineShard) {
            for (int i = 0; i < this.pipeSlices.length; ++i) {
                PipelineSlice slice = this.pipeSlices[i];
                if (slice == null) continue;
                slice.release();
                this.pipeSlices[i] = null;
            }
            this.sliceNum.set(0);
        }
    }

    public boolean disposedIfNeed() {
        return this.sliceNum.get() <= 0;
    }
}

