/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.channel;

import com.antgroup.geaflow.shuffle.api.pipeline.channel.InputChannel;
import com.antgroup.geaflow.shuffle.api.pipeline.fetcher.OneShardFetcher;
import com.antgroup.geaflow.shuffle.message.SliceId;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractInputChannel
implements InputChannel {
    private static final int BACKOFF_DISABLED = -1;
    protected final int channelIndex;
    protected final long initialBatchId;
    protected final SliceId inputSliceId;
    protected final OneShardFetcher inputFetcher;
    protected final int initialBackoff;
    protected final int maxBackoff;
    protected int currentBackoff;
    private final AtomicReference<Throwable> cause = new AtomicReference();

    protected AbstractInputChannel(int channelIndex, OneShardFetcher inputFetcher, SliceId sliceId, int initialBackoff, int maxBackoff, long startBatchId) {
        Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((initialBackoff >= 0 && initialBackoff <= maxBackoff ? 1 : 0) != 0);
        this.inputSliceId = sliceId;
        this.inputFetcher = (OneShardFetcher)Preconditions.checkNotNull((Object)inputFetcher);
        this.channelIndex = channelIndex;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.currentBackoff = initialBackoff == 0 ? -1 : 0;
        this.initialBatchId = startBatchId;
    }

    protected void notifyChannelNonEmpty() {
        this.inputFetcher.notifyChannelNonEmpty(this);
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public SliceId getInputSliceId() {
        return this.inputSliceId;
    }

    protected void checkError() throws IOException {
        Throwable t = this.cause.get();
        if (t != null) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("input channel error", t);
        }
    }

    public void setError(Throwable cause) {
        if (this.cause.compareAndSet(null, (Throwable)Preconditions.checkNotNull((Object)cause))) {
            this.notifyChannelNonEmpty();
        }
    }

    protected int getCurrentBackoff() {
        return Math.max(this.currentBackoff, 0);
    }

    protected boolean increaseBackoff() {
        if (this.currentBackoff < 0) {
            return false;
        }
        if (this.currentBackoff == 0) {
            this.currentBackoff = this.initialBackoff;
            return true;
        }
        if (this.currentBackoff < this.maxBackoff) {
            this.currentBackoff = Math.min(this.currentBackoff * 2, this.maxBackoff);
            return true;
        }
        return false;
    }
}

