/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.reader;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.shuffle.DataExchangeMode;
import com.antgroup.geaflow.shuffle.api.reader.HybridFetcher;
import com.antgroup.geaflow.shuffle.api.reader.IShuffleFetcher;
import com.antgroup.geaflow.shuffle.api.reader.PipelineFetcher;
import com.antgroup.geaflow.shuffle.network.IConnectionManager;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ShuffleFetcherFactory {
    public static IShuffleFetcher getShuffleFetcher(DataExchangeMode exchangeMode, IConnectionManager connectionManager, Configuration config) {
        return exchangeMode == DataExchangeMode.PIPELINE ? ShuffleFetcherFactory.getPipelineFetcher(connectionManager, config) : ShuffleFetcherFactory.getHybridFetcher(connectionManager, config);
    }

    public static PipelineFetcher getPipelineFetcher(IConnectionManager connectionManager, Configuration config) {
        PipelineFetcher pipelineFetcher = new PipelineFetcher();
        pipelineFetcher.setup(connectionManager, config);
        return pipelineFetcher;
    }

    public static HybridFetcher getHybridFetcher(IConnectionManager connectionManager, Configuration config) {
        Iterator<HybridFetcher> iterator = ServiceLoader.load(HybridFetcher.class).iterator();
        if (iterator.hasNext()) {
            HybridFetcher hybridFetcher = iterator.next();
            hybridFetcher.setup(connectionManager, config);
            return hybridFetcher;
        }
        throw new GeaflowRuntimeException("no hybrid fetcher impl found");
    }
}

