/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.writer;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.shuffle.DataExchangeMode;
import com.antgroup.geaflow.shuffle.api.writer.PipelineShardBuffer;
import com.antgroup.geaflow.shuffle.api.writer.ShardBuffer;
import com.antgroup.geaflow.shuffle.api.writer.SpillableShardBuffer;
import com.antgroup.geaflow.shuffle.network.IConnectionManager;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ShardBufferFactory {
    public static ShardBuffer getShardBuffer(DataExchangeMode dataExchangeMode, IConnectionManager connectionManager) {
        if (dataExchangeMode == DataExchangeMode.PIPELINE) {
            return new PipelineShardBuffer();
        }
        Iterator<SpillableShardBuffer> iterator = ServiceLoader.load(SpillableShardBuffer.class).iterator();
        if (iterator.hasNext()) {
            SpillableShardBuffer shardBuffer = iterator.next();
            shardBuffer.setConnectionManager(connectionManager);
            return shardBuffer;
        }
        throw new GeaflowRuntimeException("no shard buffer impl found");
    }
}

