/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.writer;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.shuffle.ShuffleDescriptor;
import com.antgroup.geaflow.shuffle.api.writer.IWriterContext;
import com.antgroup.geaflow.shuffle.message.PipelineInfo;

public class WriterContext
implements IWriterContext {
    private final PipelineInfo pipelineInfo;
    private int edgeId;
    private int vertexId;
    private int taskIndex;
    private int taskId;
    private String taskName;
    private int targetChannels;
    private Configuration config;
    private ShuffleDescriptor descriptor;
    private int refCount;
    private IEncoder<?> encoder;

    public WriterContext(long pipelineId, String pipelineName) {
        this.pipelineInfo = new PipelineInfo(pipelineId, pipelineName);
    }

    public WriterContext setEdgeId(int edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    public WriterContext setVertexId(int vertexId) {
        this.vertexId = vertexId;
        return this;
    }

    public WriterContext setTaskIndex(int taskIndex) {
        this.taskIndex = taskIndex;
        return this;
    }

    public WriterContext setTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public WriterContext setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public WriterContext setChannelNum(int targetChannels) {
        this.targetChannels = targetChannels;
        return this;
    }

    public WriterContext setConfig(Configuration config) {
        this.config = config;
        return this;
    }

    public WriterContext setShuffleDescriptor(ShuffleDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public WriterContext setEncoder(IEncoder<?> encoder) {
        this.encoder = encoder;
        return this;
    }

    @Override
    public PipelineInfo getPipelineInfo() {
        return this.pipelineInfo;
    }

    @Override
    public int getEdgeId() {
        return this.edgeId;
    }

    @Override
    public int getVertexId() {
        return this.vertexId;
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public int getTargetChannelNum() {
        return this.targetChannels;
    }

    @Override
    public ShuffleDescriptor getShuffleDescriptor() {
        return this.descriptor;
    }

    @Override
    public IEncoder<?> getEncoder() {
        return this.encoder;
    }

    public static WriterContextBuilder newBuilder() {
        return new WriterContextBuilder();
    }

    public static class WriterContextBuilder {
        private long pipelineId;

        public WriterContextBuilder setPipelineId(long pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public WriterContext setPipelineName(String pipelineName) {
            return new WriterContext(this.pipelineId, pipelineName);
        }
    }
}

