/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.memory;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleMemoryTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleMemoryTracker.class);
    private final long maxShuffleSize;
    private final AtomicLong usedMemory;
    private static volatile ShuffleMemoryTracker INSTANCE;

    private ShuffleMemoryTracker(Configuration config) {
        boolean memoryPool = config.getBoolean(ExecutionConfigKeys.SHUFFLE_MEMORY_POOL_ENABLE);
        double safetyFraction = config.getDouble(ExecutionConfigKeys.SHUFFLE_MEMORY_SAFETY_FRACTION);
        long maxHeapSize = (long)config.getInteger(ExecutionConfigKeys.CONTAINER_HEAP_SIZE_MB) * 0x100000L;
        long maxMemorySize = (long)((double)maxHeapSize * safetyFraction);
        double fraction = config.getDouble(ExecutionConfigKeys.SHUFFLE_HEAP_MEMORY_FRACTION);
        this.maxShuffleSize = (long)((double)maxMemorySize * fraction);
        this.usedMemory = new AtomicLong(0L);
        LOGGER.info("memoryPool:{} maxMemory:{}mb shuffleMax:{}mb", new Object[]{memoryPool, maxMemorySize / 0x100000L, this.maxShuffleSize / 0x100000L});
    }

    public static synchronized ShuffleMemoryTracker getInstance(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new ShuffleMemoryTracker(config);
        }
        return INSTANCE;
    }

    public static ShuffleMemoryTracker getInstance() {
        return INSTANCE;
    }

    public boolean requireMemory(long requiredBytes) {
        if (this.usedMemory.get() < 0L) {
            LOGGER.warn("memory statistic incorrect!");
        }
        if (requiredBytes < 0L) {
            throw new IllegalArgumentException("invalid required bytes:" + requiredBytes);
        }
        if (requiredBytes == 0L) {
            return this.maxShuffleSize >= this.usedMemory.get();
        }
        return this.maxShuffleSize >= this.usedMemory.addAndGet(requiredBytes);
    }

    public boolean checkMemoryEnough(long floatingBytes) {
        return this.usedMemory.get() + floatingBytes < this.maxShuffleSize;
    }

    public long releaseMemory(long releasedBytes) {
        return this.usedMemory.addAndGet(releasedBytes * -1L);
    }

    public long getUsedMemory() {
        return this.usedMemory.get();
    }

    public double getUsedRatio() {
        return (double)this.usedMemory.get() * 1.0 / (double)this.maxShuffleSize;
    }

    @VisibleForTesting
    public void dispose() {
        INSTANCE = null;
    }
}

