/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.message;

import com.antgroup.geaflow.shuffle.message.WriterId;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Objects;

public class SliceId
implements Serializable {
    private final WriterId writerId;
    private final int sliceIndex;

    public SliceId(long pipelineId, int edgeId, int shardIndex, int sliceIndex) {
        this.writerId = new WriterId(pipelineId, edgeId, shardIndex);
        this.sliceIndex = sliceIndex;
    }

    public SliceId(WriterId writerId, int sliceIndex) {
        this.writerId = writerId;
        this.sliceIndex = sliceIndex;
    }

    public long getPipelineId() {
        return this.writerId.getPipelineId();
    }

    public int getEdgeId() {
        return this.writerId.getEdgeId();
    }

    public int getShardIndex() {
        return this.writerId.getShardIndex();
    }

    public int getSliceIndex() {
        return this.sliceIndex;
    }

    public WriterId getWriterId() {
        return this.writerId;
    }

    public void writeTo(ByteBuf buf) {
        buf.writeLong(this.writerId.getPipelineId());
        buf.writeInt(this.writerId.getEdgeId());
        buf.writeInt(this.writerId.getShardIndex());
        buf.writeInt(this.sliceIndex);
    }

    public static SliceId readFrom(ByteBuf buf) {
        long execId = buf.readLong();
        int edgeId = buf.readInt();
        int shardIndex = buf.readInt();
        int sliceIndex = buf.readInt();
        return new SliceId(execId, edgeId, shardIndex, sliceIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliceId sliceId = (SliceId)o;
        return this.sliceIndex == sliceId.sliceIndex && Objects.equals(this.writerId, sliceId.writerId);
    }

    public int hashCode() {
        return Objects.hash(this.writerId, this.sliceIndex);
    }

    public String toString() {
        return "SliceId{pipelineId=" + this.writerId.getPipelineId() + ", edgeId=" + this.writerId.getEdgeId() + ", shardIndex=" + this.writerId.getShardIndex() + ", sliceIndex=" + this.sliceIndex + '}';
    }
}

