/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network;

import com.antgroup.geaflow.common.shuffle.ShuffleAddress;
import java.io.Serializable;
import java.net.InetSocketAddress;

public class ConnectionId
implements Serializable {
    private static final long serialVersionUID = -8068626194818666857L;
    private final InetSocketAddress address;
    private final int connectionIndex;

    public ConnectionId(ShuffleAddress shuffleAddress, int connectionIndex) {
        this.address = new InetSocketAddress(shuffleAddress.host(), shuffleAddress.port());
        this.connectionIndex = connectionIndex;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public int hashCode() {
        return this.address.hashCode() + 31 * this.connectionIndex;
    }

    public boolean equals(Object other) {
        if (other.getClass() != ConnectionId.class) {
            return false;
        }
        ConnectionId id = (ConnectionId)other;
        return id.getAddress().equals(this.address) && id.getConnectionIndex() == this.connectionIndex;
    }

    public String toString() {
        return this.address + " [" + this.connectionIndex + "]";
    }
}

