/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network;

import com.antgroup.geaflow.common.utils.ThreadUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyUtils.class);

    public static ThreadFactory getNamedThreadFactory(String name) {
        return ThreadUtil.namedThreadFactory((boolean)true, (String)name);
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        boolean preferDirect = allowDirectBufs && PlatformDependent.directBufferPreferred();
        LOGGER.info("create a PooledByteBufAllocator: preferDirect={}, allowCache={}", (Object)preferDirect, (Object)allowCache);
        return new PooledByteBufAllocator(preferDirect, Math.min(PooledByteBufAllocator.defaultNumHeapArena(), preferDirect ? 0 : numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), preferDirect ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultTinyCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultUseCacheForAllThreads() : false);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException should not have been thrown.", (Throwable)e);
        }
    }
}

