/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.LinkedList;

public class NettyFrameDecoder
extends ChannelInboundHandlerAdapter {
    private static final int LENGTH_SIZE = 4;
    private static final int MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int UNKNOWN_FRAME_SIZE = -1;
    private static final long CONSOLIDATE_THRESHOLD = 0x1400000L;
    private final LinkedList<ByteBuf> buffers = new LinkedList();
    private final ByteBuf frameLenBuf = Unpooled.buffer((int)4, (int)4);
    private final long consolidateThreshold;
    private CompositeByteBuf frameBuf = null;
    private long consolidatedFrameBufSize = 0L;
    private int consolidatedNumComponents = 0;
    private long totalSize = 0L;
    private long nextFrameSize = -1L;
    private int frameRemainingBytes = -1;

    public NettyFrameDecoder() {
        this(0x1400000L);
    }

    @VisibleForTesting
    NettyFrameDecoder(long consolidateThreshold) {
        this.consolidateThreshold = consolidateThreshold;
    }

    public void channelRead(ChannelHandlerContext ctx, Object data) throws Exception {
        ByteBuf frame;
        ByteBuf in = (ByteBuf)data;
        this.buffers.add(in);
        this.totalSize += (long)in.readableBytes();
        while (!this.buffers.isEmpty() && (frame = this.decodeNext()) != null) {
            ctx.fireChannelRead((Object)frame);
        }
    }

    private long decodeFrameSize() {
        if (this.nextFrameSize != -1L || this.totalSize < 4L) {
            return this.nextFrameSize;
        }
        ByteBuf first = this.buffers.getFirst();
        if (first.readableBytes() >= 4) {
            this.nextFrameSize = first.readInt() - 4;
            this.totalSize -= 4L;
            if (!first.isReadable()) {
                this.buffers.removeFirst().release();
            }
            return this.nextFrameSize;
        }
        while (this.frameLenBuf.readableBytes() < 4) {
            ByteBuf next = this.buffers.getFirst();
            int toRead = Math.min(next.readableBytes(), 4 - this.frameLenBuf.readableBytes());
            this.frameLenBuf.writeBytes(next, toRead);
            if (next.isReadable()) continue;
            this.buffers.removeFirst().release();
        }
        this.nextFrameSize = this.frameLenBuf.readInt() - 4;
        this.totalSize -= 4L;
        this.frameLenBuf.clear();
        return this.nextFrameSize;
    }

    private ByteBuf decodeNext() {
        long frameSize = this.decodeFrameSize();
        if (frameSize == -1L) {
            return null;
        }
        if (this.frameBuf == null) {
            Preconditions.checkArgument((frameSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Too large frame: %s", (long)frameSize);
            Preconditions.checkArgument((frameSize > 0L ? 1 : 0) != 0, (String)"Frame length should be positive: %s", (long)frameSize);
            this.frameRemainingBytes = (int)frameSize;
            if (this.buffers.isEmpty()) {
                return null;
            }
            if (this.buffers.getFirst().readableBytes() >= this.frameRemainingBytes) {
                this.frameBuf = null;
                this.nextFrameSize = -1L;
                return this.nextBufferForFrame(this.frameRemainingBytes);
            }
            this.frameBuf = this.buffers.getFirst().alloc().compositeBuffer(Integer.MAX_VALUE);
        }
        while (this.frameRemainingBytes > 0 && !this.buffers.isEmpty()) {
            ByteBuf next = this.nextBufferForFrame(this.frameRemainingBytes);
            this.frameRemainingBytes -= next.readableBytes();
            this.frameBuf.addComponent(true, next);
        }
        if ((long)this.frameBuf.capacity() - this.consolidatedFrameBufSize > this.consolidateThreshold) {
            int newNumComponents = this.frameBuf.numComponents() - this.consolidatedNumComponents;
            this.frameBuf.consolidate(this.consolidatedNumComponents, newNumComponents);
            this.consolidatedFrameBufSize = this.frameBuf.capacity();
            this.consolidatedNumComponents = this.frameBuf.numComponents();
        }
        if (this.frameRemainingBytes > 0) {
            return null;
        }
        return this.consumeCurrentFrameBuf();
    }

    private ByteBuf consumeCurrentFrameBuf() {
        CompositeByteBuf frame = this.frameBuf;
        this.frameBuf = null;
        this.consolidatedFrameBufSize = 0L;
        this.consolidatedNumComponents = 0;
        this.nextFrameSize = -1L;
        return frame;
    }

    private ByteBuf nextBufferForFrame(int bytesToRead) {
        ByteBuf frame;
        ByteBuf buf = this.buffers.getFirst();
        if (buf.readableBytes() > bytesToRead) {
            frame = buf.retain().readSlice(bytesToRead);
            this.totalSize -= (long)bytesToRead;
        } else {
            frame = buf;
            this.buffers.removeFirst();
            this.totalSize -= (long)frame.readableBytes();
        }
        return frame;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        for (ByteBuf b : this.buffers) {
            b.release();
        }
        this.buffers.clear();
        this.frameLenBuf.release();
        ByteBuf frame = this.consumeCurrentFrameBuf();
        if (frame != null) {
            frame.release();
        }
        super.handlerRemoved(ctx);
    }
}

