/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.netty;

import com.antgroup.geaflow.shuffle.config.ShuffleConfig;
import com.antgroup.geaflow.shuffle.network.ITransportContext;
import com.antgroup.geaflow.shuffle.network.NettyUtils;
import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private static final String SERVER_THREAD_GROUP_NAME = "NettyServer";
    private ServerBootstrap bootstrap;
    private ChannelFuture bindFuture;
    private ShuffleConfig config;
    private ITransportContext context;
    private PooledByteBufAllocator pooledAllocator;

    public NettyServer(ShuffleConfig config, ITransportContext transportContext) {
        this.config = config;
        this.context = transportContext;
    }

    public InetSocketAddress start() {
        int sendBufferSize;
        int receiveBufferSize;
        Preconditions.checkState((this.bootstrap == null ? 1 : 0) != 0, (Object)"Netty server has already been initialized.");
        long start = System.currentTimeMillis();
        this.bootstrap = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            this.initEpollBootstrap(this.config);
        } else {
            this.initNioBootstrap(this.config);
        }
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)(!SystemUtils.IS_OS_WINDOWS ? 1 : 0));
        this.pooledAllocator = NettyUtils.createPooledByteBufAllocator(this.config.preferDirectBuffer(), this.config.isThreadCacheEnabled(), this.config.getServerThreadsNum());
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.pooledAllocator);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)this.pooledAllocator);
        if (this.config.getServerConnectBacklog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.config.getServerConnectBacklog());
        }
        if ((receiveBufferSize = this.config.getReceiveBufferSize()) > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize);
        }
        if ((sendBufferSize = this.config.getSendBufferSize()) > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)sendBufferSize);
        }
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                channel.pipeline().addLast(NettyServer.this.context.createServerChannelHandler((Channel)channel));
            }
        });
        this.bootstrap.localAddress(this.config.getServerAddress(), this.config.getServerPort());
        this.bindFuture = this.bootstrap.bind().syncUninterruptibly();
        InetSocketAddress localAddress = (InetSocketAddress)this.bindFuture.channel().localAddress();
        long end = System.currentTimeMillis();
        LOGGER.info("Successful initialization (took {} ms). Listening on {}. NettyConfig: {}", new Object[]{end - start, localAddress.toString(), this.config});
        return localAddress;
    }

    private void initNioBootstrap(ShuffleConfig config) {
        String name = String.format("%s(%s)", SERVER_THREAD_GROUP_NAME, config.getServerPort());
        NioEventLoopGroup nioGroup = new NioEventLoopGroup(config.getServerThreadsNum(), NettyUtils.getNamedThreadFactory(name));
        this.bootstrap.group((EventLoopGroup)nioGroup).channel(NioServerSocketChannel.class);
    }

    private void initEpollBootstrap(ShuffleConfig config) {
        String name = String.format("%s(%s)", SERVER_THREAD_GROUP_NAME, config.getServerPort());
        EpollEventLoopGroup epollGroup = new EpollEventLoopGroup(config.getServerThreadsNum(), NettyUtils.getNamedThreadFactory(name));
        this.bootstrap.group((EventLoopGroup)epollGroup).channel(EpollServerSocketChannel.class);
    }

    public PooledByteBufAllocator getPooledAllocator() {
        return this.pooledAllocator;
    }

    @Override
    public void close() throws IOException {
        long start = System.currentTimeMillis();
        if (this.bindFuture != null) {
            this.bindFuture.channel().close().awaitUninterruptibly();
            this.bindFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.config().group() != null) {
            this.bootstrap.config().group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.config().childGroup() != null) {
            this.bootstrap.config().childGroup().shutdownGracefully();
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Successful shutdown (took {} ms).", (Object)(end - start));
    }
}

