/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.api.pipeline.channel.ChannelId;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;

public class BatchRequest
extends NettyMessage {
    final long nextBatchId;
    final ChannelId receiverId;

    public BatchRequest(long nextBatchId, ChannelId receiverId) {
        Preconditions.checkArgument((nextBatchId >= 0L ? 1 : 0) != 0, (Object)"The sequence id should be positive");
        this.nextBatchId = nextBatchId;
        this.receiverId = receiverId;
    }

    public ChannelId receiverId() {
        return this.receiverId;
    }

    public long getNextBatchId() {
        return this.nextBatchId;
    }

    public ByteBuf write(ByteBufAllocator allocator) throws IOException {
        ByteBuf result = null;
        try {
            result = BatchRequest.allocateBuffer(allocator, MessageType.FETCH_BATCH_REQUEST.getId(), 24);
            result.writeLong(this.nextBatchId);
            this.receiverId.writeTo(result);
            return result;
        }
        catch (Throwable t) {
            if (result != null) {
                result.release();
            }
            throw new IOException(t);
        }
    }

    public static BatchRequest readFrom(ByteBuf buffer) {
        long nextBatchId = buffer.readLong();
        ChannelId receiverId = ChannelId.readFrom(buffer);
        return new BatchRequest(nextBatchId, receiverId);
    }

    public String toString() {
        return String.format("BatchRequest(%s: %d)", this.receiverId, this.nextBatchId);
    }
}

