/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.google.common.base.Preconditions;

public enum MessageType {
    ERROR_RESPONSE(1),
    FETCH_SLICE_REQUEST(2),
    FETCH_SLICE_RESPONSE(3),
    FETCH_BATCH_REQUEST(4),
    CLOSE_CONNECTION(5),
    CANCEL_CONNECTION(6);

    private final byte id;

    private MessageType(int id) {
        Preconditions.checkArgument((id < 128 ? 1 : 0) != 0, (Object)"Cannot have more than 128 message types");
        this.id = (byte)id;
    }

    public static MessageType decode(byte id) {
        switch (id) {
            case 1: {
                return ERROR_RESPONSE;
            }
            case 2: {
                return FETCH_SLICE_REQUEST;
            }
            case 3: {
                return FETCH_SLICE_RESPONSE;
            }
            case 4: {
                return FETCH_BATCH_REQUEST;
            }
            case 5: {
                return CLOSE_CONNECTION;
            }
            case 6: {
                return CANCEL_CONNECTION;
            }
        }
        throw new IllegalArgumentException("unrecognized MessageType:" + id);
    }

    public byte getId() {
        return this.id;
    }
}

