/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.Serializable;

public abstract class NettyMessage
implements Serializable {
    public static final int FRAME_HEADER_LENGTH = 9;
    public static final int MAGIC_NUMBER = -1159983106;

    protected static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id) {
        return NettyMessage.allocateBuffer(allocator, id, -1);
    }

    static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id, int contentLength) {
        return NettyMessage.allocateBuffer(allocator, id, 0, contentLength, true);
    }

    public static ByteBuf allocateBuffer(ByteBufAllocator allocator, byte id, int messageHeaderLength, int contentLength, boolean allocateForContent) {
        Preconditions.checkArgument((contentLength <= 0x7FFFFFF6 ? 1 : 0) != 0);
        ByteBuf buffer = !allocateForContent ? allocator.buffer(9 + messageHeaderLength) : (contentLength != -1 ? allocator.buffer(9 + messageHeaderLength + contentLength) : allocator.buffer());
        buffer.writeInt(9 + messageHeaderLength + contentLength);
        buffer.writeInt(-1159983106);
        buffer.writeByte((int)id);
        return buffer;
    }

    public abstract Object write(ByteBufAllocator var1) throws Exception;
}

