/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.network.protocol.BatchRequest;
import com.antgroup.geaflow.shuffle.network.protocol.CancelRequest;
import com.antgroup.geaflow.shuffle.network.protocol.CloseRequest;
import com.antgroup.geaflow.shuffle.network.protocol.ErrorResponse;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import com.antgroup.geaflow.shuffle.network.protocol.SliceRequest;
import com.antgroup.geaflow.shuffle.network.protocol.SliceResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.ProtocolException;
import java.util.List;

@ChannelHandler.Sharable
public class NettyMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        NettyMessage decodedMsg;
        int magicNumber = msg.readInt();
        if (magicNumber != -1159983106) {
            throw new IllegalStateException("Network stream corrupted: received incorrect magic number.");
        }
        byte msgId = msg.readByte();
        MessageType msgType = MessageType.decode(msgId);
        switch (msgType) {
            case ERROR_RESPONSE: {
                decodedMsg = ErrorResponse.readFrom(msg);
                break;
            }
            case FETCH_SLICE_REQUEST: {
                decodedMsg = SliceRequest.readFrom(msg);
                break;
            }
            case FETCH_SLICE_RESPONSE: {
                decodedMsg = SliceResponse.readFrom(msg);
                break;
            }
            case FETCH_BATCH_REQUEST: {
                decodedMsg = BatchRequest.readFrom(msg);
                break;
            }
            case CLOSE_CONNECTION: {
                decodedMsg = CloseRequest.readFrom(msg);
                break;
            }
            case CANCEL_CONNECTION: {
                decodedMsg = CancelRequest.readFrom(msg);
                break;
            }
            default: {
                throw new ProtocolException("Received unknown message from producer: " + msg);
            }
        }
        out.add(decodedMsg);
    }
}

