/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.api.pipeline.channel.ChannelId;
import com.antgroup.geaflow.shuffle.message.SliceId;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;

public class SliceRequest
extends NettyMessage {
    final SliceId sliceId;
    final long startBatchId;
    final ChannelId receiverId;

    public SliceRequest(SliceId sliceId, long startBatchId, ChannelId receiverId) {
        this.sliceId = sliceId;
        this.startBatchId = startBatchId;
        this.receiverId = receiverId;
    }

    public ChannelId getReceiverId() {
        return this.receiverId;
    }

    public SliceId getSliceId() {
        return this.sliceId;
    }

    public long getStartBatchId() {
        return this.startBatchId;
    }

    public ByteBuf write(ByteBufAllocator allocator) throws IOException {
        ByteBuf result = null;
        try {
            result = SliceRequest.allocateBuffer(allocator, MessageType.FETCH_SLICE_REQUEST.getId(), 44);
            this.sliceId.writeTo(result);
            this.receiverId.writeTo(result);
            result.writeLong(this.startBatchId);
            return result;
        }
        catch (Throwable t) {
            if (result != null) {
                result.release();
            }
            throw new IOException(t);
        }
    }

    public static SliceRequest readFrom(ByteBuf buffer) {
        SliceId sliceId = SliceId.readFrom(buffer);
        ChannelId receiverId = ChannelId.readFrom(buffer);
        long startBatchId = buffer.readLong();
        return new SliceRequest(sliceId, startBatchId, receiverId);
    }

    public String toString() {
        return String.format("SliceFetchRequest(%s, startBatchId=%s)", this.sliceId, this.startBatchId);
    }
}

