/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.PipeBuffer;
import com.antgroup.geaflow.shuffle.api.pipeline.channel.ChannelId;
import com.antgroup.geaflow.shuffle.network.protocol.CompositeFileRegion;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.FileRegion;

public class SliceResponse
extends NettyMessage {
    final PipeBuffer buffer;
    final ChannelId receiverId;
    final int sequenceNumber;
    final int bufferSize;

    public SliceResponse(PipeBuffer buffer, int sequenceNumber, ChannelId inputChannelId) {
        this.buffer = buffer;
        this.sequenceNumber = sequenceNumber;
        this.receiverId = inputChannelId;
        this.bufferSize = buffer.getBuffer() != null ? buffer.getBufferSize() : 0;
    }

    public PipeBuffer getBuffer() {
        return this.buffer;
    }

    public ChannelId getReceiverId() {
        return this.receiverId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public Object write(ByteBufAllocator allocator) throws Exception {
        if (this.buffer.isData()) {
            int headerLen = 29;
            int contentSize = this.buffer.getBufferSize();
            ByteBuf headerBuf = SliceResponse.allocateBuffer(allocator, MessageType.FETCH_SLICE_RESPONSE.getId(), headerLen, contentSize, false);
            this.receiverId.writeTo(headerBuf);
            headerBuf.writeLong(this.buffer.getBatchId());
            headerBuf.writeInt(this.sequenceNumber);
            headerBuf.writeBoolean(this.buffer.isData());
            int totalSize = headerBuf.readableBytes() + contentSize;
            headerBuf.setInt(0, totalSize);
            FileRegion body = this.buffer.getBuffer().toFileRegion();
            return new CompositeFileRegion(headerBuf, body, totalSize);
        }
        ByteBuf result = SliceResponse.allocateBuffer(allocator, MessageType.FETCH_SLICE_RESPONSE.getId());
        this.receiverId.writeTo(result);
        result.writeLong(this.buffer.getBatchId());
        result.writeInt(this.sequenceNumber);
        result.writeBoolean(this.buffer.isData());
        result.writeInt(this.buffer.getCount());
        result.writeBoolean(this.buffer.isFinish());
        result.setInt(0, result.readableBytes());
        return result;
    }

    public static SliceResponse readFrom(ByteBuf buf) throws Exception {
        PipeBuffer recordBuffer;
        ChannelId inputChannelId = ChannelId.readFrom(buf);
        long batchId = buf.readLong();
        int sequenceNum = buf.readInt();
        boolean isData = buf.readBoolean();
        if (isData) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            recordBuffer = new PipeBuffer(bytes, batchId, true);
        } else {
            int count = buf.readInt();
            boolean isFinish = buf.readBoolean();
            recordBuffer = new PipeBuffer(batchId, count, false, isFinish);
        }
        return new SliceResponse(recordBuffer, sequenceNum, inputChannelId);
    }
}

