/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.serialize;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.serialize.IMessageIterator;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractMessageIterator<T>
implements IMessageIterator<T> {
    private long recordNum;
    protected T currentValue;
    protected OutBuffer outBuffer;
    protected InputStream inputStream;

    public AbstractMessageIterator(OutBuffer outBuffer) {
        this.outBuffer = outBuffer;
        this.inputStream = outBuffer.getInputStream();
    }

    public AbstractMessageIterator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public T next() {
        ++this.recordNum;
        T result = this.currentValue;
        this.currentValue = null;
        return result;
    }

    @Override
    public long getSize() {
        return this.recordNum;
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.inputStream = null;
        }
        if (this.outBuffer != null) {
            this.outBuffer.release();
            this.outBuffer = null;
        }
    }
}

