/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.serialize;

import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.serialize.IRecordSerializer;
import java.io.IOException;

public class EncoderRecordSerializer<T>
implements IRecordSerializer<T> {
    private final IEncoder<T> encoder;

    public EncoderRecordSerializer(IEncoder<T> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void serialize(T value, boolean isRetract, OutBuffer.BufferBuilder outBuffer) {
        try {
            this.encoder.encode(value, outBuffer.getOutputStream());
        }
        catch (IOException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.shuffleSerializeError(e.getMessage()), (Throwable)e);
        }
    }
}

