/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.serialize;

import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.common.serialize.impl.KryoSerializer;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.serialize.AbstractMessageIterator;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIterator<T>
extends AbstractMessageIterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageIterator.class);
    private final KryoSerializer kryoSerializer = (KryoSerializer)SerializerFactory.getKryoSerializer();
    private final Input input;

    public MessageIterator(OutBuffer outBuffer) {
        super(outBuffer);
        this.input = new Input(this.inputStream);
    }

    public MessageIterator(InputStream inputStream) {
        super(inputStream);
        this.input = new Input(inputStream);
    }

    @Override
    public boolean hasNext() {
        if (this.currentValue != null) {
            return true;
        }
        try {
            this.currentValue = this.kryoSerializer.getThreadKryo().readClassAndObject(this.input);
            return true;
        }
        catch (KryoException e) {
            if (e.getMessage().toLowerCase(Locale.ROOT).contains("buffer underflow")) {
                this.currentValue = null;
                return false;
            }
            LOGGER.error("deserialize failed", (Throwable)e);
            throw e;
        }
    }
}

