/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.service;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.shuffle.api.reader.IShuffleReader;
import com.antgroup.geaflow.shuffle.api.reader.ReaderContext;
import com.antgroup.geaflow.shuffle.api.writer.IShuffleWriter;
import com.antgroup.geaflow.shuffle.config.ShuffleConfig;
import com.antgroup.geaflow.shuffle.memory.ShuffleMemoryTracker;
import com.antgroup.geaflow.shuffle.network.netty.ConnectionManager;
import com.antgroup.geaflow.shuffle.service.IShuffleMaster;
import com.antgroup.geaflow.shuffle.service.IShuffleService;
import com.antgroup.geaflow.shuffle.service.ShuffleMasterFactory;
import com.antgroup.geaflow.shuffle.service.impl.AutoShuffleService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleManager.class);
    private static ShuffleManager INSTANCE;
    private final IShuffleService shuffleService = new AutoShuffleService();
    private final ConnectionManager connectionManager;
    private final Configuration configuration;
    private IShuffleMaster shuffleMaster;

    public ShuffleManager(Configuration config) {
        this.connectionManager = new ConnectionManager(ShuffleConfig.getInstance(config));
        this.shuffleService.init(this.connectionManager);
        this.configuration = config;
    }

    public static synchronized ShuffleManager init(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new ShuffleManager(config);
            ShuffleMemoryTracker.getInstance(config);
        }
        return INSTANCE;
    }

    public static ShuffleManager getInstance() {
        return INSTANCE;
    }

    public synchronized void initShuffleMaster() {
        if (this.shuffleMaster == null) {
            this.shuffleMaster = ShuffleMasterFactory.getShuffleMaster(this.configuration);
        }
    }

    public int getShufflePort() {
        return this.connectionManager.getShuffleAddress().port();
    }

    public IShuffleReader loadShuffleReader(Configuration config) {
        IShuffleReader reader = this.shuffleService.getReader();
        reader.init(new ReaderContext(config));
        return reader;
    }

    public IShuffleWriter loadShuffleWriter() {
        return this.shuffleService.getWriter();
    }

    public synchronized IShuffleMaster getShuffleMaster() {
        return this.shuffleMaster;
    }

    public void close() {
        LOGGER.info("closing shuffle manager");
        this.shuffleMaster.close();
        try {
            this.connectionManager.close();
        }
        catch (IOException e) {
            LOGGER.warn("close connectManager failed:{}", (Object)e.getCause(), (Object)e);
        }
    }
}

