/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.service.impl;

import com.antgroup.geaflow.shuffle.api.reader.IShuffleReader;
import com.antgroup.geaflow.shuffle.api.reader.PipelineReader;
import com.antgroup.geaflow.shuffle.api.writer.IShuffleWriter;
import com.antgroup.geaflow.shuffle.api.writer.PipelineWriter;
import com.antgroup.geaflow.shuffle.memory.ShuffleDataManager;
import com.antgroup.geaflow.shuffle.message.PipelineInfo;
import com.antgroup.geaflow.shuffle.network.IConnectionManager;
import com.antgroup.geaflow.shuffle.service.IShuffleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoShuffleService
implements IShuffleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoShuffleService.class);
    private IConnectionManager connectionManager;

    @Override
    public void init(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public IShuffleReader getReader() {
        return new PipelineReader(this.connectionManager);
    }

    @Override
    public IShuffleWriter getWriter() {
        return new PipelineWriter(this.connectionManager);
    }

    @Override
    public void clean(PipelineInfo jobInfo) {
        LOGGER.info("release shuffle data of job {}", (Object)jobInfo);
        ShuffleDataManager.getInstance().release(jobInfo.getPipelineId());
    }
}

